/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.palm.database;

import com.sun.midp.palm.database.Bitmap;
import com.sun.midp.palm.database.ClassInfo;
import com.sun.midp.palm.database.ClassPath;
import com.sun.midp.palm.database.DatabaseGenerator;
import com.sun.midp.palm.database.PalmUtil;
import com.sun.midp.palm.database.Resource;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Wrapper
extends DatabaseGenerator {
    private Vector resourceList;
    private Vector seenResources;
    private Hashtable allResources;
    ClassPath classpath;
    ClassPath systemClassPath = new ClassPath(System.getProperty("java.class.path"));
    public static final int dmHdrAttrLaunchableData = 512;
    private boolean beamable = false;
    private String dbType = null;

    public int getDBAttributes() {
        int n;
        int n2 = n = this.beamable ? 0 : 64;
        if (this.getdbType().equals("Data")) {
            n |= 0x200;
            n |= 0x40;
            n |= 8;
        }
        return n;
    }

    private void setBeamable(boolean bl) {
        this.beamable = bl;
    }

    private boolean getBeamable() {
        return this.beamable;
    }

    private void setdbType(String string) {
        this.dbType = string;
    }

    private String getdbType() {
        return this.dbType;
    }

    public void convert(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl, boolean bl2) throws IOException {
        Object object;
        ClassPath.ClassFile classFile;
        this.seenResources = new Vector();
        this.allResources = new Hashtable();
        this.setdbType(string8);
        this.setBeamable(bl);
        ClassPath.ClassFile classFile2 = this.systemClassPath.getFile("bundles" + File.separator + "SingleWrapper.prc");
        ClassPath.ClassFile classFile3 = this.systemClassPath.getFile("bundles" + File.separator + "MultipleWrapper.prc");
        if (bl2) {
            this.addResourcesFromPRC(classFile3);
        } else {
            this.addResourcesFromPRC(classFile2);
        }
        String[][] stringArray = this.readZipNames(string2);
        String[] stringArray2 = stringArray[0];
        String[] stringArray3 = stringArray[1];
        PalmUtil.sort(stringArray2);
        this.classpath = new ClassPath(string2);
        this.genResourcesFromJAR(stringArray2, stringArray3, this.classpath);
        Resource.RawResource rawResource = new Resource.RawResource(string7 + "\u0000", "tver", 1000);
        this.addOneResource(rawResource);
        this.addOneResource(new Resource.ApplicationNameResource(string4));
        int n = string.lastIndexOf(File.separatorChar);
        if (n == -1) {
            classFile = new ClassPath(".").getFile(string);
        } else {
            String string9 = string.substring(n + 1);
            object = string.substring(0, n);
            classFile = new ClassPath((String)object + File.separator).getFile(string9);
        }
        int n2 = PalmUtil.longCRC(string5) >>> 1;
        String string10 = n2 + string4;
        object = new byte[(int)classFile.length()];
        DataInputStream dataInputStream = new DataInputStream(classFile.getInputStream());
        dataInputStream.readFully((byte[])object);
        dataInputStream.close();
        this.addOneResource(new Resource.RawResource((byte[])object, "mJad", 1));
        this.writeDatabase(string3, string10, string6, string8, this.getResourceList());
        if (this.classpath != null) {
            this.classpath.close();
        }
    }

    private void addOneResource(Resource resource) {
        Resource resource2 = this.allResources.put(resource.getName(), resource);
        if (resource2 == null) {
            this.seenResources.addElement(resource.getName());
        }
        if (this.allResources.size() != this.seenResources.size()) {
            throw new RuntimeException("addOneResource confusion");
        }
    }

    private Resource[] getResourceList() {
        int n = this.seenResources.size();
        Resource[] resourceArray = new Resource[n];
        int n2 = 0;
        while (n2 < n) {
            String string = (String)this.seenResources.elementAt(n2);
            resourceArray[n2] = (Resource)this.allResources.get(string);
            ++n2;
        }
        return resourceArray;
    }

    private void addResourcesFromPRC(ClassPath.ClassFile classFile) throws IOException {
        byte[] byArray = new byte[(int)classFile.length()];
        DataInputStream dataInputStream = new DataInputStream(classFile.getInputStream());
        dataInputStream.readFully(byArray);
        dataInputStream.close();
        dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        dataInputStream.skip(32L);
        short s = dataInputStream.readShort();
        if ((s & 1) == 0) {
            System.err.println(classFile + " is not a PalmOS resource file");
            throw new RuntimeException("Bad .prc file");
        }
        dataInputStream.skip(42L);
        int n = dataInputStream.readShort();
        String[] stringArray = new String[n];
        int[] nArray = new int[n];
        int[] nArray2 = new int[n + 1];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = "" + (char)dataInputStream.readUnsignedByte() + (char)dataInputStream.readUnsignedByte() + (char)dataInputStream.readUnsignedByte() + (char)dataInputStream.readUnsignedByte();
            nArray[n2] = dataInputStream.readUnsignedShort();
            nArray2[n2] = dataInputStream.readInt();
            ++n2;
        }
        nArray2[n] = byArray.length;
        int n3 = 0;
        while (n3 < n) {
            Resource.RawResource rawResource = new Resource.RawResource(byArray, stringArray[n3], nArray[n3], nArray2[n3], nArray2[n3 + 1]);
            this.addOneResource(rawResource);
            ++n3;
        }
    }

    private String[][] readZipNames(String string) throws IOException {
        ZipEntry zipEntry;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        FileInputStream fileInputStream = new FileInputStream(string);
        if (fileInputStream.available() == 0) {
            fileInputStream.close();
            throw new IOException("Jar file size is 0");
        }
        ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (zipEntry.isDirectory()) continue;
            String string2 = zipEntry.getName();
            if (string2.endsWith(".class")) {
                String string3 = string2.substring(0, string2.length() - 6);
                vector.addElement(string3.replace('/', '.'));
                continue;
            }
            vector2.addElement(string2);
        }
        int n = vector.size();
        int n2 = vector2.size();
        Object[] objectArray = new String[n];
        Object[] objectArray2 = new String[n2];
        vector.copyInto(objectArray);
        vector2.copyInto(objectArray2);
        zipInputStream.close();
        fileInputStream.close();
        return new String[][]{objectArray, objectArray2};
    }

    private void genResourcesFromJAR(String[] stringArray, String[] stringArray2, ClassPath classPath) throws IOException {
        Resource resource;
        Object object;
        BitSet bitSet = new BitSet();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            object = new ClassInfo(string, classPath);
            resource = new Resource.ClassResource((ClassInfo)object, bitSet);
            this.addOneResource(resource);
            ++n2;
        }
        bitSet = new BitSet();
        int n3 = 0;
        while (n3 < stringArray2.length) {
            object = stringArray2[n3];
            resource = new Resource.JavaResource((String)object, classPath, bitSet);
            this.addOneResource(resource);
            ++n3;
        }
    }

    private void getIcon(String string, String string2, int n, int n2, int n3) throws IOException {
        Bitmap bitmap = null;
        if (string != null) {
            bitmap = Bitmap.read(string);
        }
        if (bitmap == null && string2 != null) {
            bitmap = Bitmap.read(string2, this.systemClassPath);
        }
        if (bitmap == null) {
            return;
        }
        if (n2 != bitmap.width || n3 != bitmap.height) {
            int n4 = (n2 - bitmap.width) / 2;
            bitmap = bitmap.resize(n2, n3);
            if (n4 != 0) {
                bitmap = bitmap.offset(n4, 0);
            }
        }
        Resource.IconResource iconResource = new Resource.IconResource(bitmap, n);
        this.addOneResource(iconResource);
    }
}

