/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.palm.database;

import com.sun.midp.palm.database.Bitmap;
import com.sun.midp.palm.database.ClassInfo;
import com.sun.midp.palm.database.ClassPath;
import com.sun.midp.palm.database.DatabaseRecord;
import com.sun.midp.palm.database.PalmUtil;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.BitSet;

abstract class Resource
extends DatabaseRecord {
    public int getFlags() {
        throw new RuntimeException("This shouldn't be called");
    }

    public int getCategory() {
        throw new RuntimeException("This shouldn't be called");
    }

    public int getUniqueID() {
        throw new RuntimeException("This shouldn't be called");
    }

    public abstract String getType();

    public abstract int getID();

    protected Resource() {
    }

    String getName() {
        int n = this.getID() & 0xFFFF;
        String string = Integer.toHexString(65536 + n).substring(1);
        return this.getType().substring(0, 4) + string;
    }

    void writeToBin() throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.getName() + ".bin");
        ((OutputStream)fileOutputStream).write(this.getBytes());
        fileOutputStream.flush();
        ((OutputStream)fileOutputStream).close();
    }

    static int IDfromCRC(String string, BitSet bitSet) {
        int n = PalmUtil.CRC(string) & 0xFFFF;
        while (bitSet.get(n)) {
            n = n + string.length() & 0xFFFF;
        }
        bitSet.set(n);
        return n;
    }

    void showPretty(PrintStream printStream, String string, boolean bl) {
        if (bl) {
            String string2 = ((this.getID() & 0xFFFF) + ":      ").substring(0, 7);
            printStream.print(this.getType() + " " + string2);
        }
        printStream.println(string);
    }

    static class ApplicationNameResource
    extends RawResource {
        ApplicationNameResource(String string) {
            super((string + "\u0000").getBytes(), "tAIN", 1000);
        }
    }

    static class IconResource
    extends Resource {
        int ID;
        byte[] bytes;
        Bitmap icon;

        IconResource(Bitmap bitmap, int n) {
            this.icon = bitmap;
            this.ID = n & 0xFFFF;
        }

        public String getType() {
            return "tAIB";
        }

        public int getID() {
            return this.ID;
        }

        public void writeBytes(DataOutput dataOutput) throws IOException {
            this.icon.writeBin(dataOutput);
        }
    }

    static class ClassResource
    extends Resource {
        ClassInfo ci;
        int ID;

        ClassResource(ClassInfo classInfo, BitSet bitSet) {
            this.ci = classInfo;
            String string = classInfo.getClassName();
            this.ID = Resource.IDfromCRC(classInfo.getClassName(), bitSet);
        }

        public String getType() {
            return "Clas";
        }

        public int getID() {
            return this.ID;
        }

        public void writeBytes(DataOutput dataOutput) throws IOException {
            dataOutput.writeBytes(this.ci.getClassName());
            dataOutput.write(0);
            int n = this.ci.hasMain() ? 0 : 2;
            dataOutput.writeInt(n << 24);
            dataOutput.write(this.ci.getBytes());
        }
    }

    static class JavaResource
    extends Resource {
        String fileName;
        byte[] bytes;
        ClassPath.ClassFile file;
        int ID;

        JavaResource(String string, ClassPath classPath, BitSet bitSet) throws IOException {
            this.fileName = string;
            this.file = classPath.getFile(string);
            this.ID = Resource.IDfromCRC(string, bitSet);
            if (this.file == null) {
                throw new IOException("Cannot find file " + string);
            }
        }

        public void writeBytes(DataOutput dataOutput) throws IOException {
            dataOutput.writeBytes(this.fileName);
            dataOutput.write(0);
            if (this.bytes == null) {
                int n = (int)this.file.length();
                this.bytes = new byte[n];
                DataInputStream dataInputStream = new DataInputStream(this.file.getInputStream());
                dataInputStream.readFully(this.bytes);
                dataInputStream.close();
            }
            dataOutput.write(this.bytes);
        }

        public String getType() {
            return "Rsrc";
        }

        public int getID() {
            return this.ID;
        }
    }

    static class FileResource
    extends Resource {
        byte[] bytes;
        String type;
        int ID;
        ClassPath.ClassFile file;

        FileResource(String string) throws IOException {
            this(string, new ClassPath("."));
        }

        FileResource(String string, ClassPath classPath) throws IOException {
            try {
                this.type = string.substring(0, 4);
                this.ID = (short)Integer.parseInt(string.substring(4, 8), 16);
            }
            catch (RuntimeException runtimeException) {
                throw new IOException("Bad filename for resource: " + string);
            }
            this.file = classPath.getFile(string);
            if (this.file == null) {
                throw new IOException("Cannot find file " + string);
            }
        }

        public void writeBytes(DataOutput dataOutput) throws IOException {
            if (this.bytes == null) {
                int n = (int)this.file.length();
                this.bytes = new byte[n];
                DataInputStream dataInputStream = new DataInputStream(this.file.getInputStream());
                dataInputStream.readFully(this.bytes);
                dataInputStream.close();
            }
            dataOutput.write(this.bytes);
        }

        public String getType() {
            return this.type;
        }

        public int getID() {
            return this.ID;
        }
    }

    static class RawResource
    extends Resource {
        byte[] bytes;
        String type;
        int ID;
        int start;
        int end;

        RawResource(byte[] byArray, String string, int n) {
            this(byArray, string, n, 0, byArray.length);
        }

        RawResource(String string, String string2, int n) {
            this(string.getBytes(), string2, n);
        }

        RawResource(byte[] byArray, String string, int n, int n2, int n3) {
            this.bytes = byArray;
            this.type = string;
            this.ID = n & 0xFFFF;
            this.start = n2;
            this.end = n3;
        }

        public String getType() {
            return this.type;
        }

        public int getID() {
            return this.ID;
        }

        public void writeBytes(DataOutput dataOutput) throws IOException {
            dataOutput.write(this.bytes, this.start, this.end - this.start);
        }
    }
}

