/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.palm.database;

public class PalmUtil {
    static final String charsInSortedOrder = "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f\u007f\u0080\u0081\u008d\u008e\u008f\u0090\u009d\u009e'-\u00ad\u0096\u0097 \u00a0\t\n\u000b\f\r!\"#$%&()*,./:;?@[\\]^\u0088_`{|}~\u00a1\u00a6\u00a8\u00af\u00b4\u00b8\u00bf\u0098\u0091\u0092\u0082\u0093\u0094\u0084\u008b\u009b+<=>\u00b1\u00ab\u00d7\u00f7\u00a2\u00a3\u00a4\u00a5\u00a7\u00a9\u00ac\u00ae\u00b0\u00b5\u00b6\u00b7\u0086\u0087\u0095\u0085\u00890\u00bc\u00ba\u00bd\u00be1\u00b92\u00b23\u00b3456789aA\u00aa\u00e1\u00c1\u00e0\u00c0\u00e2\u00c2\u00e4\u00c4\u00e3\u00c3\u00e5\u00c5\u00e6\u00c6bBcC\u00e7\u00c7dD\u00f0\u00d0eE\u00e9\u00c9\u00e8\u00c8\u00ea\u00ca\u00eb\u00cbfF\u0083gGhHiI\u00ed\u00cd\u00ec\u00cc\u00ee\u00ce\u00cfjJk\u00efKlLmMnN\u00f1\u00d1oO\u00bb\u00f3\u00d3\u00f2\u00d2\u00f4\u00d4\u00f6\u00d6\u00f5\u00d5\u00f8\u00d8\u009c\u008cpPqQrRsS\u009a\u008a\u00dftT\u00fe\u00de\u0099uU\u00fa\u00da\u00f9\u00d9\u00fb\u00db\u00fc\u00dcvVwWxXyY\u00fd\u00dd\u00ff\u009fzZ";
    private static final int[] sortOrder = new int[256];
    private static final int[] CRC_Table_16;
    private static final int[] CRC_Table_32;

    public static int CRC(String string) {
        int[] nArray = CRC_Table_16;
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 = n2 << 8 ^ nArray[(n2 >> 8 ^ string.charAt(n3)) & 0xFF];
            ++n3;
        }
        return n2 & 0xFFFF;
    }

    public static int longCRC(String string) {
        int[] nArray = CRC_Table_32;
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = n2 >>> 8;
            int n5 = nArray[(n2 ^ string.charAt(n3)) & 0xFF];
            n2 = n4 ^ n5;
            ++n3;
        }
        return n2;
    }

    public static void sort(String[] stringArray) {
        String[] stringArray2 = (String[])stringArray.clone();
        PalmUtil.mergeSort(stringArray2, stringArray, 0, stringArray.length);
    }

    public static int compare(String string, String string2) {
        int n = string.length();
        int n2 = string2.length();
        int n3 = Math.min(n, n2);
        int n4 = 0;
        while (n4 < n3) {
            char c;
            char c2 = string.charAt(n4);
            if (c2 != (c = string2.charAt(n4))) {
                return sortOrder[c2] - sortOrder[c];
            }
            ++n4;
        }
        return n - n2;
    }

    private static void mergeSort(String[] stringArray, String[] stringArray2, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 7) {
            int n4 = n;
            while (n4 < n2) {
                int n5 = n4;
                while (n5 > n && PalmUtil.compare(stringArray2[n5 - 1], stringArray2[n5]) > 0) {
                    String string = stringArray2[n5 - 1];
                    stringArray2[n5 - 1] = stringArray2[n5];
                    stringArray2[n5] = string;
                    --n5;
                }
                ++n4;
            }
            return;
        }
        int n6 = (n + n2) / 2;
        PalmUtil.mergeSort(stringArray2, stringArray, n, n6);
        PalmUtil.mergeSort(stringArray2, stringArray, n6, n2);
        if (PalmUtil.compare(stringArray[n6 - 1], stringArray[n6]) <= 0) {
            System.arraycopy(stringArray, n, stringArray2, n, n3);
            return;
        }
        int n7 = n;
        int n8 = n;
        int n9 = n6;
        while (n7 < n2) {
            stringArray2[n7] = n9 >= n2 || n8 < n6 && PalmUtil.compare(stringArray[n8], stringArray[n9]) <= 0 ? stringArray[n8++] : stringArray[n9++];
            ++n7;
        }
    }

    static {
        int n = 0;
        while (n < 256) {
            PalmUtil.sortOrder[charsInSortedOrder.charAt((int)n) & 0xFF] = n;
            ++n;
        }
        CRC_Table_16 = new int[]{0, 4129, 8258, 12387, 16516, 20645, 24774, 28903, 33032, 37161, 41290, 45419, 49548, 53677, 57806, 61935, 4657, 528, 12915, 8786, 21173, 17044, 29431, 25302, 37689, 33560, 45947, 41818, 54205, 50076, 62463, 58334, 9314, 13379, 1056, 5121, 25830, 29895, 17572, 21637, 42346, 46411, 34088, 38153, 58862, 62927, 50604, 54669, 13907, 9842, 5649, 1584, 30423, 26358, 22165, 18100, 46939, 42874, 38681, 34616, 63455, 59390, 55197, 51132, 18628, 22757, 26758, 30887, 2112, 6241, 10242, 14371, 51660, 55789, 59790, 63919, 35144, 39273, 43274, 47403, 23285, 19156, 31415, 27286, 6769, 2640, 14899, 10770, 56317, 52188, 64447, 60318, 39801, 35672, 47931, 43802, 27814, 31879, 19684, 23749, 11298, 15363, 3168, 7233, 60846, 64911, 52716, 56781, 44330, 48395, 36200, 40265, 32407, 28342, 24277, 20212, 15891, 11826, 7761, 3696, 65439, 61374, 57309, 53244, 48923, 44858, 40793, 36728, 37256, 33193, 45514, 41451, 53516, 49453, 61774, 57711, 4224, 161, 12482, 8419, 20484, 16421, 28742, 24679, 33721, 37784, 41979, 46042, 49981, 54044, 58239, 62302, 689, 4752, 8947, 13010, 16949, 21012, 25207, 29270, 46570, 42443, 38312, 34185, 62830, 58703, 54572, 50445, 13538, 9411, 5280, 1153, 29798, 25671, 21540, 17413, 42971, 47098, 34713, 38840, 59231, 63358, 50973, 55100, 9939, 14066, 1681, 5808, 26199, 30326, 17941, 22068, 55628, 51565, 63758, 59695, 39368, 35305, 47498, 43435, 22596, 18533, 30726, 26663, 6336, 2273, 14466, 10403, 52093, 56156, 60223, 64286, 35833, 39896, 43963, 48026, 19061, 23124, 27191, 31254, 2801, 6864, 10931, 14994, 64814, 60687, 56684, 52557, 48554, 44427, 40424, 36297, 31782, 27655, 23652, 19525, 15522, 11395, 7392, 3265, 61215, 65342, 53085, 57212, 44955, 49082, 36825, 40952, 28183, 32310, 20053, 24180, 11923, 16050, 3793, 7920};
        CRC_Table_32 = new int[]{0, 1996959894, -301047508, -1727442502, 124634137, 1886057615, -379345611, -1637575261, 249268274, 2044508324, -522852066, -1747789432, 162941995, 2125561021, -407360249, -1866523247, 498536548, 1789927666, -205950648, -2067906082, 450548861, 1843258603, -187386543, -2083289657, 325883990, 1684777152, -43845254, -1973040660, 335633487, 1661365465, -99664541, -1928851979, 997073096, 1281953886, -715111964, -1570279054, 1006888145, 1258607687, -770865667, -1526024853, 901097722, 1119000684, -608450090, -1396901568, 853044451, 1172266101, -589951537, -1412350631, 651767980, 1373503546, -925412992, -1076862698, 565507253, 1454621731, -809855591, -1195530993, 671266974, 1594198024, -972236366, -1324619484, 795835527, 1483230225, -1050600021, -1234817731, 1994146192, 31158534, -1731059524, -271249366, 1907459465, 112637215, -1614814043, -390540237, 2013776290, 251722036, -1777751922, -519137256, 2137656763, 141376813, -1855689577, -429695999, 1802195444, 476864866, -2056965928, -228458418, 1812370925, 453092731, -2113342271, -183516073, 1706088902, 314042704, -1950435094, -54949764, 1658658271, 366619977, -1932296973, -69972891, 1303535960, 984961486, -1547960204, -725929758, 1256170817, 1037604311, -1529756563, -740887301, 1131014506, 879679996, -1385723834, -631195440, 1141124467, 855842277, -1442165665, -586318647, 1342533948, 654459306, -1106571248, -921952122, 1466479909, 544179635, -1184443383, -832445281, 1591671054, 702138776, -1328506846, -942167884, 1504918807, 783551873, -1212326853, -1061524307, -306674912, -1698712650, 62317068, 1957810842, -355121351, -1647151185, 81470997, 1943803523, -480048366, -1805370492, 225274430, 2053790376, -468791541, -1828061283, 167816743, 2097651377, -267414716, -2029476910, 503444072, 1762050814, -144550051, -2140837941, 426522225, 1852507879, -19653770, -1982649376, 282753626, 1742555852, -105259153, -1900089351, 397917763, 1622183637, -690576408, -1580100738, 953729732, 1340076626, -776247311, -1497606297, 1068828381, 1219638859, -670225446, -1358292148, 906185462, 1090812512, -547295293, -1469587627, 829329135, 1181335161, -882789492, -1134132454, 628085408, 1382605366, -871598187, -1156888829, 570562233, 1426400815, -977650754, -1296233688, 733239954, 1555261956, -1026031705, -1244606671, 752459403, 1541320221, -1687895376, -328994266, 1969922972, 40735498, -1677130071, -351390145, 1913087877, 83908371, -1782625662, -491226604, 2075208622, 213261112, -1831694693, -438977011, 2094854071, 198958881, -2032938284, -237706686, 1759359992, 534414190, -2118248755, -155638181, 1873836001, 414664567, -2012718362, -15766928, 1711684554, 285281116, -1889165569, -127750551, 1634467795, 376229701, -1609899400, -686959890, 1308918612, 956543938, -1486412191, -799009033, 1231636301, 1047427035, -1362007478, -640263460, 1088359270, 936918000, -1447252397, -558129467, 1202900863, 817233897, -1111625188, -893730166, 1404277552, 615818150, -1160759803, -841546093, 1423857449, 601450431, -1285129682, -1000256840, 1567103746, 711928724, -1274298825, -1022587231, 1510334235, 755167117};
    }
}

