/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.palm.database;

import com.sun.midp.midletsuite.InvalidJadException;
import com.sun.midp.midletsuite.InvalidJarException;
import com.sun.midp.midletsuite.JadManager;
import com.sun.midp.midletsuite.JarManager;
import com.sun.midp.palm.database.Bitmap;
import com.sun.midp.palm.database.ClassInfo;
import com.sun.midp.palm.database.ClassPath;
import com.sun.midp.palm.database.DatabaseGenerator;
import com.sun.midp.palm.database.PalmUtil;
import com.sun.midp.palm.database.Resource;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class MakeMIDPApp
extends DatabaseGenerator {
    public static final int dmHdrAttrLaunchableData = 512;
    public static final int dmHdrAttrBackup = 8;
    String usageName = "java com.sun.midp.palm.database.MakeMIDPApp";
    int verbose = 0;
    String userClassPathString;
    String userBootClassPathString = null;
    String dbCreator;
    String dbType = "appl";
    String dbName;
    String shortName;
    String outputFile;
    String mainClass;
    String[] additionalClasses;
    String iconName = "NOICON";
    String smallIconName;
    String jarFile;
    String jadFile;
    Vector resourceList;
    boolean beamable = true;
    boolean emptyApp = false;
    boolean JARtoPRC = true;
    ClassPath classpath;
    ClassPath systemClassPath = new ClassPath(System.getProperty("java.class.path"));
    public static final String defaultWrapperName = "com" + File.separator + "sun" + File.separator + "midp" + File.separator + "palm" + File.separator + "database" + File.separator + "Wrapper.prc";
    public static final String tinyIconName = "com" + File.separator + "sun" + File.separator + "midp" + File.separator + "palm" + File.separator + "database" + File.separator + "DefaultTiny.bmp";
    public String wrapperName = System.getProperty("midp.wrapper", defaultWrapperName);
    private Hashtable allResources = new Hashtable();
    private Vector seenResources = new Vector();

    public int getDBAttributes() {
        int n;
        int n2 = n = this.beamable ? 0 : 64;
        if (this.dbType.equals("Data")) {
            n |= 0x200;
            n |= 0x40;
            n |= 8;
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        MakeMIDPApp makeMIDPApp = null;
        ResourceBundle resourceBundle = ResourceBundle.getBundle("bundles.MakeMIDPApp", Locale.getDefault());
        try {
            makeMIDPApp = new MakeMIDPApp(stringArray);
        }
        catch (InvalidJarException invalidJarException) {
            int n = invalidJarException.getReason();
            System.err.println("JAR Error:" + resourceBundle.getString(new Integer(n).toString()));
        }
        catch (InvalidJadException invalidJadException) {
            int n = invalidJadException.getReason();
            System.err.println("JAD Error:" + resourceBundle.getString(new Integer(n).toString()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    MakeMIDPApp(String[] stringArray) throws IOException, InvalidJadException {
        Object object;
        Object object2;
        Object object3;
        String[] stringArray2;
        Object object4;
        JarManager jarManager = null;
        if (!this.parseArguments(stringArray)) {
            return;
        }
        ClassPath.ClassFile classFile = this.systemClassPath.getFile(this.wrapperName);
        if (classFile == null) {
            System.err.println("Cannot find wrapper code \"" + this.wrapperName + "\" in classpath");
            return;
        }
        this.addResourcesFromPRC(classFile);
        if (this.JARtoPRC) {
            jarManager = new JarManager();
            jarManager.loadManifest(this.jarFile);
            if (this.dbName == null) {
                object4 = jarManager.getMIDletVendor();
                stringArray2 = jarManager.getMIDletName();
                int n = PalmUtil.longCRC((String)object4) >>> 1;
                this.dbName = n + (String)stringArray2;
            }
            if (this.shortName == null) {
                this.shortName = jarManager.getMIDletName();
            }
            if (this.outputFile == null) {
                object4 = this.jadFile != null ? this.jadFile.substring(0, this.jadFile.length() - 4) : (this.jarFile != null ? this.jarFile.substring(0, this.jarFile.length() - 4) : "result");
                this.outputFile = (String)object4 + ".prc";
            }
            object4 = this.readZipNames(this.jarFile);
            stringArray2 = object4[0];
            object3 = object4[1];
            PalmUtil.sort(stringArray2);
            this.classpath = new ClassPath(this.jarFile);
            this.genResourcesFromJAR(stringArray2, (String[])object3, this.classpath);
            object2 = new Resource.RawResource(jarManager.getMIDletVersion() + "\u0000", "tver", 1000);
            this.addOneResource((Resource)object2);
        } else if (!this.emptyApp) {
            this.addResourcesFromClasses();
        }
        if (this.resourceList != null) {
            object4 = new BitSet();
            stringArray2 = new ClassPath(this.userClassPathString);
            object3 = this.resourceList.elements();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                object = new Resource.JavaResource((String)object2, (ClassPath)stringArray2, (BitSet)object4);
                this.addOneResource((Resource)object);
                if (this.verbose <= 0) continue;
                ((Resource)object).showPretty(System.out, (String)object2, this.verbose > 1);
            }
        }
        if (!this.iconName.equals("NOICON")) {
            this.getIcon(this.iconName, null, 1000, 32, 32);
            this.getIcon(this.smallIconName, tinyIconName, 1001, 15, 9);
        }
        this.addOneResource(new Resource.ApplicationNameResource(this.shortName));
        if (this.jadFile != null) {
            int n = this.jadFile.lastIndexOf(File.separatorChar);
            if (n == -1) {
                object4 = new ClassPath(".").getFile(this.jadFile);
            } else {
                object3 = this.jadFile.substring(n + 1);
                object2 = this.jadFile.substring(0, n);
                object4 = new ClassPath((String)object2).getFile((String)object3);
            }
            if (object4 == null) {
                throw new FileNotFoundException("JAD file not found.");
            }
            object3 = new byte[(int)((ClassPath.ClassFile)object4).length()];
            object2 = new DataInputStream(((ClassPath.ClassFile)object4).getInputStream());
            ((DataInputStream)object2).readFully((byte[])object3);
            ((FilterInputStream)object2).close();
            object = new JadManager();
            ((JadManager)object).load(new ByteArrayInputStream((byte[])object3));
            if (this.JARtoPRC) {
                ((JadManager)object).testWithJARmanifest(jarManager);
            }
            this.addOneResource(new Resource.RawResource((byte[])object3, "mJad", 1));
        }
        if (this.verbose > 0) {
            System.out.println("Generating output file \"" + this.outputFile + "\".");
        }
        this.writeDatabase(this.outputFile, this.dbName, this.dbCreator, this.dbType, this.getResourceList());
    }

    private void addResourcesFromPRC(ClassPath.ClassFile classFile) throws IOException {
        byte[] byArray = new byte[(int)classFile.length()];
        DataInputStream dataInputStream = new DataInputStream(classFile.getInputStream());
        dataInputStream.readFully(byArray);
        dataInputStream.close();
        dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        dataInputStream.skip(32L);
        short s = dataInputStream.readShort();
        if ((s & 1) == 0) {
            System.err.println(classFile + " is not a PalmOS resource file");
            throw new RuntimeException("Bad .prc file");
        }
        dataInputStream.skip(42L);
        int n = dataInputStream.readShort();
        String[] stringArray = new String[n];
        int[] nArray = new int[n];
        int[] nArray2 = new int[n + 1];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = "" + (char)dataInputStream.readUnsignedByte() + (char)dataInputStream.readUnsignedByte() + (char)dataInputStream.readUnsignedByte() + (char)dataInputStream.readUnsignedByte();
            nArray[n2] = dataInputStream.readUnsignedShort();
            nArray2[n2] = dataInputStream.readInt();
            ++n2;
        }
        nArray2[n] = byArray.length;
        int n3 = 0;
        while (n3 < n) {
            Resource.RawResource rawResource = new Resource.RawResource(byArray, stringArray[n3], nArray[n3], nArray2[n3], nArray2[n3 + 1]);
            this.addOneResource(rawResource);
            ++n3;
        }
    }

    private String[][] readZipNames(String string) throws IOException {
        ZipEntry zipEntry;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(string));
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (zipEntry.isDirectory()) continue;
            String string2 = zipEntry.getName();
            if (string2.endsWith(".class")) {
                String string3 = string2.substring(0, string2.length() - 6);
                vector.addElement(string3.replace('/', '.'));
                continue;
            }
            vector2.addElement(string2);
        }
        int n = vector.size();
        int n2 = vector2.size();
        Object[] objectArray = new String[n];
        Object[] objectArray2 = new String[n2];
        vector.copyInto(objectArray);
        vector2.copyInto(objectArray2);
        return new String[][]{objectArray, objectArray2};
    }

    private void addResourcesFromClasses() throws IOException {
        Resource resource;
        Object object;
        ClassInfo[] classInfoArray;
        BitSet bitSet = new BitSet();
        ClassPath classPath = new ClassPath(this.userClassPathString);
        ClassPath classPath2 = null;
        if (this.userBootClassPathString != null) {
            classPath2 = new ClassPath(this.userBootClassPathString);
        }
        if ((classInfoArray = ClassInfo.classClosure(this.mainClass, this.additionalClasses, classPath, classPath2)) == null) {
            System.exit(1);
        }
        int n = 0;
        while (n < classInfoArray.length) {
            object = classInfoArray[n];
            resource = new Resource.ClassResource((ClassInfo)object, bitSet);
            this.addOneResource(resource);
            if (this.verbose > 0) {
                resource.showPretty(System.out, ((ClassInfo)object).getClassName(), this.verbose > 1);
            }
            ++n;
        }
        object = this.mainClass.replace('.', '/');
        resource = new Resource.RawResource((String)object, "Main", 1);
        this.addOneResource(resource);
        if (this.verbose > 0) {
            resource.showPretty(System.out, '\"' + (String)object + '\"', this.verbose > 1);
        }
    }

    private void genResourcesFromJAR(String[] stringArray, String[] stringArray2, ClassPath classPath) throws IOException {
        Resource resource;
        Object object;
        BitSet bitSet = new BitSet();
        ClassPath classPath2 = new ClassPath(this.userClassPathString);
        ClassPath classPath3 = null;
        if (this.userBootClassPathString != null) {
            classPath3 = new ClassPath(this.userBootClassPathString);
        }
        if (stringArray == null) {
            System.exit(1);
        }
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            object = new ClassInfo(string, classPath);
            resource = new Resource.ClassResource((ClassInfo)object, bitSet);
            this.addOneResource(resource);
            if (this.verbose > 0) {
                resource.showPretty(System.out, ((ClassInfo)object).getClassName(), this.verbose > 1);
            }
            ++n2;
        }
        bitSet = new BitSet();
        int n3 = 0;
        while (n3 < stringArray2.length) {
            object = stringArray2[n3];
            resource = new Resource.JavaResource((String)object, classPath, bitSet);
            this.addOneResource(resource);
            if (this.verbose > 0) {
                resource.showPretty(System.out, (String)object, this.verbose > 1);
            }
            ++n3;
        }
    }

    private void getIcon(String string, String string2, int n, int n2, int n3) {
        Bitmap bitmap = null;
        if (string != null) {
            try {
                bitmap = Bitmap.read(string);
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
        }
        if (bitmap == null && string2 != null) {
            try {
                bitmap = Bitmap.read(string2, this.systemClassPath);
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
        }
        if (bitmap == null) {
            return;
        }
        if (n2 != bitmap.width || n3 != bitmap.height) {
            if (this.verbose > 0) {
                System.out.println("Resizing bitmap from " + bitmap.width + "x" + bitmap.height + " to " + n2 + "x" + n3 + ".");
            }
            int n4 = (n2 - bitmap.width) / 2;
            bitmap = bitmap.resize(n2, n3);
            if (n4 != 0) {
                bitmap = bitmap.offset(n4, 0);
            }
        }
        Resource.IconResource iconResource = new Resource.IconResource(bitmap, n);
        this.addOneResource(iconResource);
        if (this.verbose > 0) {
            String string3 = n == 1000 ? "Large icon" : "Small icon";
            iconResource.showPretty(System.out, string3, this.verbose > 1);
        }
    }

    private boolean parseArguments(String[] stringArray) {
        String string;
        int n = 0;
        while (n < stringArray.length) {
            block34: {
                string = stringArray[n];
                if (!string.startsWith("-")) break;
                try {
                    if (string.equals("-v") || string.equals("-verbose")) {
                        ++this.verbose;
                        break block34;
                    }
                    if (string.equals("-nobeam")) {
                        this.beamable = false;
                        break block34;
                    }
                    if (string.equals("-Xempty")) {
                        this.emptyApp = true;
                        this.JARtoPRC = false;
                        break block34;
                    }
                    if (string.equals("-Xclasspath")) {
                        System.out.println("Obsoleted option: -Xclasspath");
                        ++n;
                        break block34;
                    }
                    if (string.equals("-Xbootclasspath")) {
                        System.out.println("Obsoleted option: -Xbootclasspath");
                        ++n;
                        break block34;
                    }
                    if (string.equals("-JARtoPRC")) {
                        System.out.println("Obsoleted option: -JARtoPRC");
                        ++n;
                        break block34;
                    }
                    if (string.equals("-icon")) {
                        this.iconName = stringArray[++n];
                        break block34;
                    }
                    if (string.equals("-smallicon")) {
                        this.smallIconName = stringArray[++n];
                        break block34;
                    }
                    if (string.equals("-longname")) {
                        this.dbName = stringArray[++n];
                        break block34;
                    }
                    if (string.equals("-o") || string.equals("-outfile")) {
                        this.outputFile = stringArray[++n];
                        break block34;
                    }
                    if (string.equals("-name")) {
                        this.shortName = stringArray[++n];
                        break block34;
                    }
                    if (string.equals("-creator")) {
                        this.dbCreator = (stringArray[++n] + "    ").substring(0, 4);
                        break block34;
                    }
                    if (string.equals("-type")) {
                        this.dbType = (stringArray[++n] + "    ").substring(0, 4);
                        break block34;
                    }
                    if (string.equals("-version")) {
                        System.out.println("Obsoleted option: -version");
                        ++n;
                        break block34;
                    }
                    if (string.equals("-networking")) {
                        System.out.println("Obsoleted option: -networking");
                        break block34;
                    }
                    if (string.equals("-nonetworking")) {
                        System.out.println("Obsoleted option: -nonetworking");
                        break block34;
                    }
                    if (string.equals("-help")) {
                        this.usage();
                        return false;
                    }
                    if (string.equals("-jad")) {
                        this.jadFile = stringArray[++n];
                        break block34;
                    }
                    System.err.println("Invalid flag: " + string);
                    this.usage();
                    return false;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    System.err.println(stringArray[stringArray.length - 1] + " requires an argument");
                    return false;
                }
            }
            ++n;
        }
        if (this.userClassPathString == null) {
            this.userClassPathString = ".";
        }
        if (!this.emptyApp && n == stringArray.length) {
            System.err.println("No JAR file given");
            this.usage();
            return false;
        }
        if (this.verbose > 2) {
            System.err.println("Verbose level up to 2 only.");
        }
        if (!this.emptyApp) {
            this.jarFile = stringArray[n++];
            if (!this.jarFile.toLowerCase().endsWith(".jar") && !this.jarFile.toLowerCase().endsWith(".zip")) {
                System.err.println("Error:" + this.jarFile + " is not a valid jar file");
                this.usage();
                return false;
            }
        }
        this.mainClass = "Empty";
        string = !this.emptyApp ? this.mainClass.substring(this.mainClass.lastIndexOf(46) + 1) : this.mainClass;
        if (this.dbName == null && !this.JARtoPRC) {
            this.dbName = this.mainClass;
        }
        if (this.shortName == null && !this.JARtoPRC) {
            this.shortName = string;
        }
        if (this.outputFile == null && !this.JARtoPRC) {
            this.outputFile = string + ".prc";
        }
        if (this.dbCreator == null) {
            if (this.dbType.equals("appl")) {
                System.out.println("Illegal combination: empty creator with appl type");
                return false;
            }
            this.dbCreator = new String("mJav");
            if (this.verbose > 1) {
                System.out.println("Creator id = " + this.dbCreator);
            }
        } else if ("mJav".equals(this.dbCreator) && "appl".equals(this.dbType)) {
            System.out.println("Illegal combination: creator ID mJav and type appl is reserved for JavaHQ");
            return false;
        }
        return true;
    }

    private void addOneResource(Resource resource) {
        Resource resource2 = this.allResources.put(resource.getName(), resource);
        if (resource2 == null) {
            this.seenResources.addElement(resource.getName());
        }
        if (this.allResources.size() != this.seenResources.size()) {
            throw new RuntimeException("addOneResource confusion");
        }
    }

    private Resource[] getResourceList() {
        int n = this.seenResources.size();
        Resource[] resourceArray = new Resource[n];
        int n2 = 0;
        while (n2 < n) {
            String string = (String)this.seenResources.elementAt(n2);
            resourceArray[n2] = (Resource)this.allResources.get(string);
            ++n2;
        }
        return resourceArray;
    }

    private void usage() {
        System.err.println("Usage: " + this.usageName + " [-options] <JAR file>");
        System.err.println();
        System.err.print("where options include:\n-v                 Verbose output (-v -v gives even more information)\n-verbose           Same as -v\n-icon <file>       File containing icon for application.\n                   Must be in bmp, pbm, or bin (Palm Resource) format.\n-smallicon <file>  Same as -smallicon\n-name <name>       Short name of application, seen in the launcher\n-longname <name>   Long name for the application, seen in beaming, etc\n-creator <crid>    Creator ID for the application\n-type <type>       File type for application (default is appl)\n-outfile <outfile> Name of file to create on local disk;\n                   This is the file that is downloaded to the Palm\n-o <outfile>       Same as -outfile\n-version <string>  Change version\n-help              Print this message\n-jad <file>        Specify a file for JAD, MIDlet Suite Packaging\n");
    }
}

