/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.palm.database;

import com.sun.midp.palm.database.ClassInfo;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;

abstract class DatabaseRecord {
    static final int dmRecAttrSecret = 16;
    static final int dmRecAttrBusy = 32;
    static final int dmRecAttrDirty = 64;
    static final int dmRecAttrDelete = 128;
    protected byte[] bytes;

    DatabaseRecord() {
    }

    abstract int getFlags() throws IOException;

    abstract int getCategory() throws IOException;

    public byte[] getBytes() throws IOException {
        if (this.bytes == null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            this.writeBytes(dataOutputStream);
            dataOutputStream.flush();
            dataOutputStream.close();
            this.bytes = byteArrayOutputStream.toByteArray();
        }
        return this.bytes;
    }

    public void writeBytes(DataOutput dataOutput) throws IOException {
        dataOutput.write(this.getBytes());
    }

    public int getUniqueID() {
        return -1;
    }

    static class ClassRecord
    extends DatabaseRecord {
        ClassInfo ci;
        int type;
        public static final int ApplicationMainFlag = 0;
        public static final int CoreJavaFlag = 1;
        public static final int ApplicationInternalFlag = 2;

        ClassRecord(ClassInfo classInfo, boolean bl) {
            this.ci = classInfo;
            this.type = bl ? 1 : (classInfo.hasMain() ? 0 : 2);
        }

        public void writeBytes(DataOutput dataOutput) throws IOException {
            dataOutput.writeBytes(this.ci.getClassName());
            dataOutput.write(0);
            dataOutput.writeInt(this.type << 24);
            dataOutput.write(this.ci.getBytes());
        }

        public int getCategory() {
            return this.ci.hasMain() ? 1 : 2;
        }

        public int getFlags() {
            return 0;
        }
    }
}

