/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.palm.database;

import com.sun.midp.palm.database.DatabaseRecord;
import com.sun.midp.palm.database.Resource;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DatabaseGenerator {
    static final int dmHdrAttrResDB = 1;
    static final int dmHdrAttrReadOnly = 2;
    static final int dmHdrAttrAppInfoDirty = 4;
    static final int dmHdrAttrBackup = 8;
    static final int dmHdrAttrOKToInstallNewer = 16;
    static final int dmHdrAttrResetAfterInstall = 32;
    static final int dmHdrAttrCopyPrevention = 64;
    static final int dmHdrAttrStream = 128;
    static final int dmHdrAttrHideMe = 256;
    static final int dmHdrAttrShowMe = 512;
    static final int dmHdrAttrOpen = 32768;
    static final int MAXIMUM_RECORD_SIZE = 65500;
    private static long epoch;
    private int now = DatabaseGenerator.getPalmOSDate(new Date());

    public static int getPalmOSDate(Date date) {
        return (int)((date.getTime() - epoch) / 1000L);
    }

    public int getVersion() {
        return 1;
    }

    public int getCreationDate() {
        return this.now;
    }

    public int getModificationDate() {
        return this.now;
    }

    public int getLastBackupDate() {
        return this.now;
    }

    public int getModificationNumber() {
        return 1;
    }

    public int getDBAttributes() {
        return 0;
    }

    public void dumpAppInfo(DataOutput dataOutput) {
    }

    public void dumpSortInfo(DataOutput dataOutput) {
    }

    public long writeDatabase(String string, String string2, String string3, String string4, DatabaseRecord[] databaseRecordArray) throws IOException {
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        int n = databaseRecordArray.length;
        boolean bl = n > 0 && databaseRecordArray[0] instanceof Resource;
        long[] lArray = new long[n + 1];
        randomAccessFile.seek(80 + n * (bl ? 10 : 8));
        long l = randomAccessFile.getFilePointer();
        this.dumpAppInfo(randomAccessFile);
        if (randomAccessFile.getFilePointer() - l > 65500L) {
            DatabaseGenerator.warnTooBig("Application Info");
        }
        long l2 = randomAccessFile.getFilePointer();
        this.dumpSortInfo(randomAccessFile);
        if (randomAccessFile.getFilePointer() - l2 > 65500L) {
            DatabaseGenerator.warnTooBig("Sort Info");
        }
        int n2 = 0;
        while (n2 < n) {
            lArray[n2] = randomAccessFile.getFilePointer();
            databaseRecordArray[n2].writeBytes(randomAccessFile);
            if (randomAccessFile.getFilePointer() - lArray[n2] > 65500L) {
                if (bl) {
                    Resource resource = (Resource)databaseRecordArray[n2];
                    DatabaseGenerator.warnTooBig("Resource \"" + resource.getType() + " " + resource.getID() + "\"");
                } else {
                    DatabaseGenerator.warnTooBig("Database entry #" + n2);
                }
            }
            ++n2;
        }
        randomAccessFile.seek(0L);
        DatabaseGenerator.writeString(randomAccessFile, string2, 31, '\u0000');
        randomAccessFile.writeByte(0);
        randomAccessFile.writeShort(this.getDBAttributes() | (bl ? 1 : 0));
        randomAccessFile.writeShort(this.getVersion());
        randomAccessFile.writeInt(this.getCreationDate());
        randomAccessFile.writeInt(this.getModificationDate());
        randomAccessFile.writeInt(this.getLastBackupDate());
        randomAccessFile.writeInt(this.getModificationNumber());
        randomAccessFile.writeInt(l == l2 ? 0 : (int)l);
        randomAccessFile.writeInt(l2 == lArray[0] ? 0 : (int)l2);
        DatabaseGenerator.writeString(randomAccessFile, string4, 4, ' ');
        DatabaseGenerator.writeString(randomAccessFile, string3, 4, ' ');
        randomAccessFile.writeInt(0);
        randomAccessFile.writeInt(0);
        randomAccessFile.writeShort(n);
        DatabaseGenerator.checkFileOffset(randomAccessFile, 78L);
        if (bl) {
            int n3 = 0;
            while (n3 < n) {
                Resource resource = (Resource)databaseRecordArray[n3];
                DatabaseGenerator.writeString(randomAccessFile, resource.getType(), 4, ' ');
                randomAccessFile.writeShort(resource.getID());
                randomAccessFile.writeInt((int)lArray[n3]);
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n) {
                DatabaseRecord databaseRecord = databaseRecordArray[n4];
                int n5 = databaseRecord.getUniqueID();
                if (n5 < 0) {
                    n5 = n4 + 1;
                }
                randomAccessFile.writeInt((int)lArray[n4]);
                randomAccessFile.writeByte(databaseRecord.getFlags() | databaseRecord.getCategory());
                randomAccessFile.writeByte((byte)(n5 >> 16));
                randomAccessFile.writeShort((short)n5);
                ++n4;
            }
        }
        randomAccessFile.writeShort(0);
        DatabaseGenerator.checkFileOffset(randomAccessFile, l);
        randomAccessFile.close();
        return lArray[n];
    }

    protected static void writeString(DataOutput dataOutput, String string, int n, char c) throws IOException {
        int n2 = string.length();
        if (n2 <= n) {
            dataOutput.writeBytes(string);
            int n3 = n2;
            while (n3 < n) {
                dataOutput.write(c);
                ++n3;
            }
        } else {
            dataOutput.writeBytes(string.substring(0, n));
        }
    }

    private static void checkFileOffset(RandomAccessFile randomAccessFile, long l) throws IOException {
        long l2 = randomAccessFile.getFilePointer();
        if (l2 != l) {
            System.err.println("Bad file offset.  Expected: " + l + "; " + "Actual: " + l2);
            throw new IOException("Bad offset");
        }
    }

    private static void warnTooBig(String string) {
        System.err.println("WARNING: " + string + " may be too large.  Hotsync may fail.");
    }

    static {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(1904, 0, 1, 0, 0, 0);
        ((Calendar)gregorianCalendar).setTimeZone(TimeZone.getTimeZone("GMT"));
        epoch = gregorianCalendar.getTime().getTime();
    }
}

