/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.palm.database;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ClassPath {
    private ClassPathEntry[] path;
    private String pathString;

    public ClassPath(String string) {
        this.pathString = string;
        Vector<ClassPathEntry> vector = new Vector<ClassPathEntry>();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            Object object;
            int n3 = string.indexOf(File.pathSeparator, n2);
            if (n3 == -1) {
                n3 = n;
            }
            if (n2 == n3) {
                object = new File(".");
                vector.addElement(new DirectoryClassPathEntry((File)object));
            } else {
                object = string.substring(n2, n3);
                File file = new File((String)object);
                if (file.isFile()) {
                    try {
                        ZipFile zipFile = new ZipFile(file);
                        vector.addElement(new ZipClassPathEntry(zipFile));
                    }
                    catch (ZipException zipException) {
                    }
                    catch (IOException iOException) {}
                } else {
                    vector.addElement(new DirectoryClassPathEntry(file));
                }
            }
            n2 = n3 + 1;
        }
        this.path = new ClassPathEntry[vector.size()];
        vector.copyInto(this.path);
    }

    public ClassFile getFile(String string) {
        int n = 0;
        while (n < this.path.length) {
            ClassFile classFile = this.path[n].getFile(string);
            if (classFile != null) {
                return classFile;
            }
            ++n;
        }
        return null;
    }

    public void close() throws IOException {
        int n = this.path.length;
        while (--n >= 0) {
            this.path[n].close();
        }
    }

    public String toString() {
        return this.pathString;
    }

    static class DirectoryClassPathEntry
    extends ClassPathEntry {
        final File dir;
        private Hashtable subdirs = new Hashtable(29);

        DirectoryClassPathEntry(File file) {
            this.dir = file;
        }

        ClassFile getFile(String string) {
            File file = null;
            int n = string.lastIndexOf(File.separatorChar);
            String string2 = string.substring(0, n + 1);
            String string3 = string.substring(n + 1);
            String[] stringArray = this.getFiles(string2);
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (string3.equals(stringArray[n2])) {
                    file = new File(this.dir.getPath(), string);
                    break;
                }
                ++n2;
            }
            if (file == null) {
                return null;
            }
            File file2 = file;
            return new ClassFile(this, file2){
                private final /* synthetic */ File val$xfile;
                private final /* synthetic */ DirectoryClassPathEntry this$0;
                {
                    this.this$0 = directoryClassPathEntry;
                    this.val$xfile = file;
                }

                public long length() {
                    return this.val$xfile.length();
                }

                public InputStream getInputStream() throws IOException {
                    return new FileInputStream(this.val$xfile);
                }
            };
        }

        private String[] getFiles(String string) {
            String[] stringArray = (String[])this.subdirs.get(string);
            if (stringArray == null) {
                File file = new File(this.dir.getPath(), string);
                if (file.isDirectory()) {
                    stringArray = file.list();
                    if (stringArray == null) {
                        stringArray = new String[]{};
                    }
                } else {
                    stringArray = new String[]{};
                }
                this.subdirs.put(string, stringArray);
            }
            return stringArray;
        }
    }

    static class ZipClassPathEntry
    extends ClassPathEntry {
        final ZipFile zipFile;

        ZipClassPathEntry(ZipFile zipFile) {
            this.zipFile = zipFile;
        }

        ClassFile getFile(String string) {
            String string2 = string.replace(File.separatorChar, '/');
            ZipEntry zipEntry = this.zipFile.getEntry(string2);
            if (zipEntry != null) {
                return new ClassFile(this, zipEntry){
                    private final /* synthetic */ ZipEntry val$zipEntry;
                    private final /* synthetic */ ZipClassPathEntry this$0;
                    {
                        this.this$0 = zipClassPathEntry;
                        this.val$zipEntry = zipEntry;
                    }

                    public long length() {
                        return this.val$zipEntry.getSize();
                    }

                    public InputStream getInputStream() throws IOException {
                        try {
                            return this.this$0.zipFile.getInputStream(this.val$zipEntry);
                        }
                        catch (ZipException zipException) {
                            throw new IOException(zipException.getMessage());
                        }
                    }
                };
            }
            return null;
        }

        public void close() throws IOException {
            this.zipFile.close();
        }
    }

    static abstract class ClassPathEntry {
        ClassPathEntry() {
        }

        abstract ClassFile getFile(String var1);

        public void close() throws IOException {
        }
    }

    public static abstract class ClassFile {
        public abstract long length();

        public abstract InputStream getInputStream() throws IOException;
    }
}

