/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.palm.database;

import com.sun.midp.palm.database.ClassPath;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;

public class ClassInfo {
    public static final int CONSTANT_Utf8 = 1;
    public static final int CONSTANT_Unicode = 2;
    public static final int CONSTANT_Integer = 3;
    public static final int CONSTANT_Float = 4;
    public static final int CONSTANT_Long = 5;
    public static final int CONSTANT_Double = 6;
    public static final int CONSTANT_Class = 7;
    public static final int CONSTANT_String = 8;
    public static final int CONSTANT_Field = 9;
    public static final int CONSTANT_Method = 10;
    public static final int CONSTANT_InterfaceMethod = 11;
    public static final int CONSTANT_NameAndType = 12;
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SYNCHRONIZED = 32;
    public static final int ACC_VOLATILE = 64;
    public static final int ACC_TRANSIENT = 128;
    public static final int ACC_NATIVE = 256;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    public static final int ACC_SUPER = 32;
    private Object[] pool;
    private Vector classReferences = new Vector();
    private String className;
    private boolean hasMain;
    private Vector natives;
    private byte[] bytes;

    public String getClassName() {
        return this.className;
    }

    public boolean hasMain() {
        return this.hasMain;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    ClassInfo(String string) throws IOException {
        File file = new File(string);
        int n = (int)file.length();
        FileInputStream fileInputStream = new FileInputStream(string);
        this.bytes = new byte[n];
        if (((InputStream)fileInputStream).read(this.bytes) != n) {
            throw new IOException("Failed to read " + string);
        }
        ((InputStream)fileInputStream).close();
        this.readClassFile();
    }

    ClassInfo(byte[] byArray) throws IOException {
        this.bytes = byArray;
        this.readClassFile();
    }

    ClassInfo(String string, ClassPath classPath) throws IOException {
        if (string.indexOf(47) != -1 || string.indexOf(92) != -1) {
            throw new IOException("Bad classname " + string);
        }
        String string2 = string.replace('.', File.separatorChar) + ".class";
        ClassPath.ClassFile classFile = classPath.getFile(string2);
        if (classFile == null) {
            throw new IOException("Cannot find file " + string2);
        }
        DataInputStream dataInputStream = new DataInputStream(classFile.getInputStream());
        this.bytes = new byte[(int)classFile.length()];
        dataInputStream.readFully(this.bytes);
        dataInputStream.close();
        this.readClassFile();
    }

    private void readClassFile() throws IOException {
        int n;
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.bytes));
        dataInputStream.skipBytes(8);
        this.readConstantPool(dataInputStream);
        int n2 = dataInputStream.readUnsignedShort();
        int n3 = dataInputStream.readUnsignedShort();
        int n4 = dataInputStream.readUnsignedShort();
        this.className = this.className(n3);
        int n5 = dataInputStream.readUnsignedShort();
        int n6 = 0;
        while (n6 < n5) {
            n = dataInputStream.readUnsignedShort();
            this.classReferences.addElement(this.className(n));
            ++n6;
        }
        n5 = dataInputStream.readUnsignedShort();
        n = 0;
        while (n < n5) {
            dataInputStream.skipBytes(6);
            this.skipAttributes(dataInputStream);
            ++n;
        }
        n5 = dataInputStream.readUnsignedShort();
        int n7 = 0;
        while (n7 < n5) {
            int n8 = dataInputStream.readUnsignedShort();
            int n9 = dataInputStream.readUnsignedShort();
            int n10 = dataInputStream.readUnsignedShort();
            String string = (String)this.pool[n9];
            String string2 = (String)this.pool[n10];
            this.skipAttributes(dataInputStream);
            if (string.equals("main") && string2.equals("([Ljava/lang/String;)V") && (n8 & 1) != 0) {
                this.hasMain = true;
            }
            if ((n8 & 0x100) != 0) {
                if (this.natives == null) {
                    this.natives = new Vector();
                }
                this.natives.addElement(string);
            }
            ++n7;
        }
        this.skipAttributes(dataInputStream);
    }

    void skipAttributes(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedShort();
        int n2 = 0;
        while (n2 < n) {
            int n3 = dataInput.readUnsignedShort();
            int n4 = dataInput.readInt();
            dataInput.skipBytes(n4);
            ++n2;
        }
    }

    void readConstantPool(DataInput dataInput) throws IOException {
        int n;
        int n2 = dataInput.readUnsignedShort();
        Object[] objectArray = new Object[n2];
        int[] nArray = new int[n2];
        objectArray[0] = nArray;
        int n3 = 1;
        while (n3 < n2) {
            nArray[n3] = n = dataInput.readUnsignedByte();
            switch (n) {
                case 7: 
                case 8: {
                    objectArray[n3] = new Integer(dataInput.readUnsignedShort());
                    break;
                }
                case 1: {
                    objectArray[n3] = dataInput.readUTF();
                    break;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    dataInput.skipBytes(4);
                    break;
                }
                case 5: 
                case 6: {
                    dataInput.skipBytes(8);
                    ++n3;
                    break;
                }
                default: {
                    System.err.println("Unknown tag " + n);
                }
            }
            ++n3;
        }
        this.pool = objectArray;
        n = 1;
        while (n < n2) {
            block10: {
                String string;
                block11: {
                    if (nArray[n] != 7) break block10;
                    string = this.className(n);
                    if (string.charAt(0) != '[') break block11;
                    int n4 = string.length();
                    if (string.charAt(n4 - 1) != ';') break block10;
                    int n5 = string.indexOf(76);
                    string = string.substring(n5 + 1, n4 - 1);
                }
                this.classReferences.addElement(string);
            }
            ++n;
        }
    }

    String className(int n) {
        int n2 = (Integer)this.pool[n];
        return (String)this.pool[n2];
    }

    static ClassInfo[] classClosure(String string, String[] stringArray, ClassPath classPath, ClassPath classPath2) {
        Object[] objectArray;
        int n;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Vector<String> vector = new Vector<String>();
        Vector<ClassInfo> vector2 = new Vector<ClassInfo>();
        boolean bl = false;
        hashtable.put(string, string);
        vector.addElement(string);
        if (stringArray != null) {
            n = 0;
            while (n < stringArray.length) {
                String string2 = stringArray[n];
                if (hashtable.get(string2) == null) {
                    hashtable.put(string2, string2);
                    vector.addElement(string2);
                }
                ++n;
            }
        }
        n = vector.size();
        int n2 = 0;
        while (n2 < vector.size()) {
            block12: {
                ClassInfo classInfo;
                objectArray = (Object[])vector.elementAt(n2);
                if (classPath2 != null) {
                    try {
                        classInfo = new ClassInfo((String)objectArray, classPath2);
                        if (n2 >= n) break block12;
                        vector2.addElement(classInfo);
                        break block12;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                try {
                    classInfo = new ClassInfo((String)objectArray, classPath);
                }
                catch (IOException iOException) {
                    System.err.println("ERROR: " + iOException);
                    bl = true;
                    break block12;
                }
                vector2.addElement(classInfo);
                Vector vector3 = classInfo.classReferences;
                int n3 = 0;
                while (n3 < vector3.size()) {
                    String string3 = (String)vector3.elementAt(n3);
                    if (hashtable.get(string3 = string3.replace('/', '.')) == null) {
                        hashtable.put(string3, string3);
                        vector.addElement(string3);
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        if (bl) {
            return null;
        }
        objectArray = new ClassInfo[vector2.size()];
        vector2.copyInto(objectArray);
        return objectArray;
    }
}

