/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.palm.database;

import com.sun.midp.palm.database.ClassPath;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;

public class Bitmap {
    int width;
    int height;
    int rowSize;
    int flags;
    byte[] bytes;
    byte[] compressedBytes;
    static final int BITMAP_COMPRESSED_FLAG = 32768;

    Bitmap(int n, int n2, int n3, byte[] byArray, int n4) {
        this.width = n;
        this.height = n2;
        this.rowSize = n3;
        this.bytes = byArray;
        this.flags = n4;
    }

    Bitmap(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.rowSize = (n + 15 & 0xFFFFFFF0) / 8;
        this.bytes = new byte[this.rowSize * n2];
    }

    public static Bitmap read(String string) throws IOException {
        return Bitmap.read(string, new FileInputStream(string));
    }

    public static Bitmap read(String string, ClassPath classPath) throws IOException {
        return Bitmap.read(string, classPath.getFile(string).getInputStream());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Bitmap read(String string, InputStream inputStream) throws IOException {
        Bitmap bitmap;
        DataInputStream dataInputStream;
        block6: {
            Bitmap bitmap2;
            block5: {
                Bitmap bitmap3;
                block4: {
                    dataInputStream = new DataInputStream(inputStream);
                    try {
                        if (string.endsWith(".bmp")) {
                            bitmap3 = Bitmap.readBMP(dataInputStream);
                            Object var5_6 = null;
                            break block4;
                        }
                        if (string.endsWith(".pbm")) {
                            bitmap2 = Bitmap.readPBM(dataInputStream);
                            break block5;
                        }
                        if (!string.endsWith(".bin")) throw new IOException("Unknown file extension");
                        bitmap = Bitmap.readBIN(dataInputStream);
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var5_9 = null;
                        dataInputStream.close();
                        throw throwable;
                    }
                }
                dataInputStream.close();
                return bitmap3;
            }
            Object var5_7 = null;
            dataInputStream.close();
            return bitmap2;
        }
        Object var5_8 = null;
        dataInputStream.close();
        return bitmap;
    }

    private static Bitmap readBMP(DataInput dataInput) throws IOException {
        dataInput.skipBytes(10);
        int n = Bitmap.x86Long(dataInput);
        int n2 = Bitmap.x86Long(dataInput);
        int n3 = Bitmap.x86Long(dataInput);
        int n4 = Bitmap.x86Long(dataInput);
        dataInput.skipBytes(2);
        int n5 = Bitmap.x86Word(dataInput);
        int n6 = Bitmap.x86Long(dataInput);
        if (n5 != 1) {
            throw new IOException("Cannot read " + n5 + "-bit bitmaps");
        }
        if (n6 != 0) {
            throw new IOException("Can't handle compressed bitmap");
        }
        dataInput.skipBytes(20);
        byte[] byArray = new byte[8];
        dataInput.readFully(byArray);
        int n7 = (n3 + 31 & 0xFFFFFFE0) / 8;
        int n8 = (n3 + 15 & 0xFFFFFFF0) / 8;
        byte[] byArray2 = new byte[n8 * n4];
        if (n != 62) {
            System.out.println("SrcOffset <> 62???");
            if (n > 62) {
                dataInput.skipBytes(n - 62);
            } else {
                throw new IOException("Malformed bitmap file");
            }
        }
        int n9 = 0;
        while (n9 < n4) {
            int n10 = n4 - n9 - 1;
            int n11 = n10 * n8;
            dataInput.readFully(byArray2, n11, n8);
            dataInput.skipBytes(n7 - n8);
            ++n9;
        }
        Bitmap bitmap = new Bitmap(n3, n4, n8, byArray2, 0);
        if ((byArray[0] & 0xFF) < (byArray[4] & 0xFF)) {
            bitmap.invert();
        } else {
            bitmap.cleanupBits();
        }
        return bitmap;
    }

    private void invert() {
        int n = this.bytes.length;
        int n2 = 0;
        while (n2 < n) {
            this.bytes[n2] = ~this.bytes[n2];
            ++n2;
        }
        this.cleanupBits();
        this.compressedBytes = null;
        this.flags &= 0xFFFF7FFF;
    }

    private void cleanupBits() {
        int n = this.width;
        int n2 = this.rowSize;
        byte[] byArray = this.bytes;
        int n3 = byArray.length;
        int n4 = -65536 >> (n - 1 & 0xF) + 1;
        int n5 = n4 >> 8 & 0xFF;
        int n6 = n4 & 0xFF;
        int n7 = 0;
        while (n7 < byArray.length) {
            int n8 = n7 + n2 - 2;
            byArray[n8] = (byte)(byArray[n8] & n5);
            int n9 = n7 + n2 - 1;
            byArray[n9] = (byte)(byArray[n9] & n6);
            n7 += n2;
        }
    }

    private static Bitmap readPBM(DataInput dataInput) throws IOException {
        String string = dataInput.readLine();
        if (string.charAt(0) != 'P') {
            throw new IOException("Not a PBM file");
        }
        char c = string.charAt(1);
        if (c != '1' && c != '4') {
            throw new IOException("Not a monochrome file");
        }
        String string2 = dataInput.readLine() + " ";
        int n = 0;
        while (Character.isWhitespace(string2.charAt(n))) {
            ++n;
        }
        int n2 = n;
        while (Character.isDigit(string2.charAt(n2))) {
            ++n2;
        }
        int n3 = Integer.parseInt(string2.substring(n, n2));
        n = n2;
        while (Character.isWhitespace(string2.charAt(n))) {
            ++n;
        }
        n2 = n;
        while (Character.isDigit(string2.charAt(n2))) {
            ++n2;
        }
        int n4 = Integer.parseInt(string2.substring(n, n2));
        Bitmap bitmap = new Bitmap(n3, n4);
        if (c == '1') {
            bitmap.readAsciiPBM(dataInput);
        } else {
            bitmap.readRawPBM(dataInput);
        }
        return bitmap;
    }

    static Bitmap readBIN(DataInput dataInput) throws IOException {
        short s = dataInput.readShort();
        short s2 = dataInput.readShort();
        int n = dataInput.readShort();
        short s3 = dataInput.readShort();
        byte[] byArray = new byte[n * s2];
        Bitmap bitmap = new Bitmap(s, s2, n, byArray, s3);
        dataInput.skipBytes(8);
        if ((s3 & 0x8000) == 0) {
            dataInput.readFully(byArray);
        } else {
            int n2 = dataInput.readUnsignedByte();
            int n3 = dataInput.readUnsignedByte();
            int n4 = (n2 << 8) + n3;
            byte[] byArray2 = new byte[n4];
            byArray2[0] = (byte)n2;
            byArray2[1] = (byte)n3;
            dataInput.readFully(byArray2, 2, n4 - 2);
            byte by = 0;
            int n5 = 2;
            int n6 = 0;
            while (n6 < byArray.length) {
                int n7 = n6 - n;
                int n8 = 0;
                while (n8 < n) {
                    if ((n8 & 7) == 0) {
                        by = byArray2[n5++];
                    }
                    boolean bl = (by & 128 >> (n8 & 7)) == 0;
                    byArray[n6 + n8] = bl ? byArray[n7 + n8] : byArray2[n5++];
                    ++n8;
                }
                n6 += n;
            }
            bitmap.compressedBytes = byArray2;
        }
        return bitmap;
    }

    public Bitmap resize(int n, int n2) {
        Bitmap bitmap = new Bitmap(n, n2);
        int n3 = Math.min(this.height, n2);
        int n4 = Math.min(this.rowSize, bitmap.rowSize);
        int n5 = 0;
        while (n5 < n3) {
            System.arraycopy(this.bytes, n5 * this.rowSize, bitmap.bytes, n5 * bitmap.rowSize, n4);
            ++n5;
        }
        return bitmap;
    }

    public Bitmap offset(int n, int n2) {
        int n3 = this.width;
        int n4 = this.height;
        Bitmap bitmap = new Bitmap(n3, n4);
        int n5 = 0;
        while (n5 < n4) {
            int n6 = n5 + n2;
            if (n6 >= 0 && n6 < n4) {
                int n7 = 0;
                while (n7 < n3) {
                    int n8 = n7 + n;
                    if (n8 >= 0 && n8 < n3 && this.getBit(n7, n5)) {
                        bitmap.setBit(n8, n6);
                    }
                    ++n7;
                }
            }
            ++n5;
        }
        return bitmap;
    }

    private boolean getBit(int n, int n2) {
        int n3 = n2 * this.rowSize + (n >> 3);
        int n4 = 128 >> (n & 7);
        return (this.bytes[n3] & n4) != 0;
    }

    private void setBit(int n, int n2) {
        if (n < 0 || n >= this.width || n2 < 0 || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = n2 * this.rowSize + (n >> 3);
        int n4 = 128 >> (n & 7);
        int n5 = n3;
        this.bytes[n5] = (byte)(this.bytes[n5] | n4);
        this.compressedBytes = null;
        this.flags &= 0xFFFF7FFF;
    }

    private void readAsciiPBM(DataInput dataInput) throws IOException {
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                int n3;
                while ((n3 = dataInput.readByte() & 0xFF) != 48 && n3 != 49) {
                }
                if (n3 == 49) {
                    int n4 = n * this.rowSize + (n2 >> 3);
                    this.bytes[n4] = (byte)(this.bytes[n4] | 1 << 7 - (n2 & 7));
                }
                ++n2;
            }
            ++n;
        }
    }

    private void readRawPBM(DataInput dataInput) throws IOException {
        int n = (this.width + 7 & 0xFFFFFFF8) / 8;
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.height) {
            dataInput.readFully(this.bytes, n3, n);
            ++n2;
            n3 += this.rowSize;
        }
    }

    private void error(String string) throws IOException {
        System.err.println(string);
        throw new IOException();
    }

    private static int x86Word(DataInput dataInput) throws IOException {
        return dataInput.readUnsignedByte() + (dataInput.readUnsignedByte() << 8);
    }

    private static int x86Long(DataInput dataInput) throws IOException {
        return Bitmap.x86Word(dataInput) + (Bitmap.x86Word(dataInput) << 16);
    }

    public void writeBin(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.width);
        dataOutput.writeShort(this.height);
        dataOutput.writeShort(this.rowSize);
        dataOutput.writeShort(this.flags);
        dataOutput.writeLong(0L);
        byte[] byArray = (this.flags & 0x8000) != 0 ? this.compressedBytes : this.bytes;
        dataOutput.write(byArray);
        if ((byArray.length & 1) == 1) {
            dataOutput.write(0);
        }
    }

    private void show() {
        System.out.println("width=" + this.width + "  height=" + this.height + " rowSize=" + this.rowSize);
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                System.out.print(this.getBit(n2, n) ? "#" : ".");
                ++n2;
            }
            System.out.print("  ");
            int n3 = 0;
            while (n3 < this.rowSize) {
                int n4 = this.bytes[n * this.rowSize + n3] & 0xFF;
                String string = Integer.toHexString(n4);
                if (string.length() == 1) {
                    string = "0" + string;
                }
                System.out.print(string + " ");
                ++n3;
            }
            System.out.println();
            ++n;
        }
    }

    private void dumpJava(String string, String string2, String string3) throws IOException {
        PrintStream printStream = System.out;
        boolean bl = false;
        if (!string3.equals("-")) {
            printStream = new PrintStream(new FileOutputStream(string3));
            bl = true;
        }
        printStream.println("Bitmap " + string2 + " = new Bitmap((short)" + this.rowSize + ", " + "new byte[] {");
        printStream.println("    // File " + string + ";  size: " + this.width + "x" + this.height);
        int n = 0;
        while (n < this.bytes.length) {
            if (n % 8 == 0) {
                printStream.print(n == 0 ? "    " : ",\n    ");
            } else {
                printStream.print(", ");
            }
            printStream.print(this.formatNumber(this.bytes[n], 4));
            ++n;
        }
        printStream.println("\n});");
        if (bl) {
            printStream.flush();
            printStream.close();
        }
    }

    private void dumpJavaNew(String string, String string2, String string3) throws IOException {
        PrintStream printStream = System.out;
        boolean bl = false;
        if (!string3.equals("-")) {
            printStream = new PrintStream(new FileOutputStream(string3));
            bl = true;
        }
        boolean bl2 = (this.flags & 0x8000) != 0;
        printStream.println("Bitmap " + string2 + " = new Bitmap(new short[] {");
        printStream.println("    // File " + string + ";  size: " + this.width + "x" + this.height + (bl2 ? " (compressed) " : ""));
        printStream.println("    // header");
        printStream.println("    " + this.formatNumber((short)this.width, 6) + ", " + this.formatNumber((short)this.height, 6) + ", " + this.formatNumber((short)this.rowSize, 6) + ", " + this.formatNumber((short)this.flags, 6) + ", " + this.formatNumber(0, 6) + ", " + this.formatNumber(0, 6) + ", " + this.formatNumber(0, 6) + ", " + this.formatNumber(0, 6) + ", ");
        byte[] byArray = bl2 ? this.compressedBytes : this.bytes;
        printStream.println("    // bits");
        int n = 0;
        while (n < byArray.length) {
            if (n % 16 == 0) {
                printStream.print(n == 0 ? "    " : ",\n    ");
            } else {
                printStream.print(", ");
            }
            int n2 = byArray[n] << 8;
            try {
                n2 += byArray[n + 1] & 0xFF;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            printStream.print(this.formatNumber(n2, 6));
            n += 2;
        }
        printStream.println("\n});");
        if (bl) {
            printStream.flush();
            printStream.close();
        }
    }

    private String formatNumber(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer().append(n).reverse();
        int n3 = stringBuffer.length();
        while (n3 < n2) {
            stringBuffer.append(' ');
            ++n3;
        }
        return stringBuffer.reverse().toString();
    }

    public boolean compress(boolean bl) {
        int n;
        int n2;
        int n3 = this.rowSize;
        int n4 = this.height;
        byte[] byArray = this.bytes;
        byte[] byArray2 = new byte[2 + 2 * n3 * n4];
        int n5 = 2;
        int n6 = -1;
        int n7 = 0;
        while (n7 < byArray.length) {
            n2 = n7 - n3;
            n = 0;
            while (n < n3) {
                byte by = byArray[n7 + n];
                if ((n & 7) == 0) {
                    n6 = n5++;
                    byArray2[n6] = 0;
                }
                if (n2 < 0 || by != byArray[n2 + n]) {
                    int n8 = n6;
                    byArray2[n8] = (byte)(byArray2[n8] | 128 >> (n & 7));
                    byArray2[n5++] = by;
                }
                ++n;
            }
            n7 += n3;
        }
        n2 = n5 + 16;
        n = byArray.length + 16;
        double d = (double)n2 / (double)n;
        DecimalFormat decimalFormat = new DecimalFormat("(#.##%)");
        System.out.println("Uncompressed size: " + n + " bytes; " + "compressed size: " + n2 + " bytes; " + decimalFormat.format(d));
        if (bl || n5 < byArray.length) {
            byArray2[0] = (byte)(n5 >> 8);
            byArray2[1] = (byte)(n5 & 0xFF);
            this.compressedBytes = new byte[n5];
            System.arraycopy(byArray2, 0, this.compressedBytes, 0, n5);
            this.flags |= 0x8000;
            return true;
        }
        System.out.println("Bitmap not compressed");
        return false;
    }

    private static void usage() {
        System.err.print("Usage:\n    java palm.database.Bitmap <bitmapFile> commands . . . .\n\nwhere commands include\n\n-help                    Print this help command\n-resize <width> <height> Resize the bitmap\n-expand <width> <height> Like resize, but centers the old bitmap\n-compress                Creates a \"compressed\" bitmap, if this saves space\n-Compress                Like -compress, but always performs compression\n-uncompress              Undo any compression\n-invert                  Invert the bitmap (exchange black and white)\n-show                    Print the bitmap on the screen as ascii art\n-dump <varName> <file>   Output a Java statement to create this bitmap\n                         Use \"-\" as file to write to standard output\n-Dump <varName> <file>   Use an alternative Java bitmap constructor\n                         arguments are the same as -dump\n-write <file>            Write the bitmap to a file.  (In Palm format)\n\n");
    }
}

