/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.midletsuite;

import com.sun.midp.midletsuite.InvalidJarException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class JarManager {
    private int fileSize = 0;
    private int numOfMidlet = 0;
    private String MIDletName;
    private String MIDletVersion;
    private String MIDletVendor;
    private String MIDProfile;
    private String MIDConfig;
    private String MIDletDesc;
    private String MIDletIcon;
    private String MIDletInfoURL;
    private String MIDletDataSize;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadManifest(String string) throws InvalidJarException, IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            this.fileSize = fileInputStream.available();
            if (this.fileSize == 0) {
                fileInputStream.close();
                throw new InvalidJarException(9010);
            }
            this.loadManifest(fileInputStream);
            Object var4_3 = null;
            if (fileInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (fileInputStream == null) throw throwable;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadManifest(InputStream inputStream) throws InvalidJarException, IOException {
        JarInputStream jarInputStream = null;
        try {
            jarInputStream = new JarInputStream(inputStream);
            Manifest manifest = jarInputStream.getManifest();
            if (manifest == null) {
                throw new InvalidJarException(1060);
            }
            Attributes attributes = manifest.getMainAttributes();
            this.MIDletName = attributes.getValue("MIDlet-Name");
            if (this.MIDletName == null) {
                throw new InvalidJarException(1000);
            }
            this.MIDletVersion = attributes.getValue("MIDlet-Version");
            if (this.MIDletVersion == null) {
                throw new InvalidJarException(1020);
            }
            this.MIDletVendor = attributes.getValue("MIDlet-Vendor");
            if (this.MIDletVendor == null) {
                throw new InvalidJarException(1010);
            }
            this.MIDProfile = attributes.getValue("MicroEdition-Profile");
            if (this.MIDProfile == null) {
                throw new InvalidJarException(1080);
            }
            this.MIDConfig = attributes.getValue("MicroEdition-Configuration");
            if (this.MIDConfig == null) {
                throw new InvalidJarException(1070);
            }
            this.MIDletDesc = attributes.getValue("MIDlet-Description");
            this.MIDletIcon = attributes.getValue("MIDlet-Icon");
            this.MIDletInfoURL = attributes.getValue("MIDlet-Info-URL");
            this.MIDletDataSize = attributes.getValue("MIDlet-Data-Size");
            int n = 0;
            Iterator<Object> iterator = attributes.keySet().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                if (!string.startsWith("MIDlet-")) continue;
                String string2 = string.substring(7);
                try {
                    n = Integer.decode(string2);
                    ++this.numOfMidlet;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (n == 0) {
                throw new InvalidJarException(1050);
            }
            Object var11_10 = null;
            if (jarInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (jarInputStream == null) throw throwable;
            jarInputStream.close();
            throw throwable;
        }
        jarInputStream.close();
    }

    public int getNumMidlets() {
        return this.numOfMidlet;
    }

    public boolean isMultipleMidlets() {
        return this.numOfMidlet > 1;
    }

    public String getMIDletName() {
        return this.MIDletName;
    }

    public String getMIDletVersion() {
        return this.MIDletVersion;
    }

    public String getMIDletVendor() {
        return this.MIDletVendor;
    }

    public String getMIDProfile() {
        return this.MIDProfile;
    }

    public String getMIDConfig() {
        return this.MIDConfig;
    }

    public String getMIDletDescription() {
        return this.MIDletDesc;
    }

    public String getMIDletIcon() {
        return this.MIDletIcon;
    }

    public String getMIDletInfoURL() {
        return this.MIDletInfoURL;
    }

    public String getMIDletDataSize() {
        return this.MIDletDataSize;
    }

    public int getFileSize() {
        return this.fileSize;
    }
}

