/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.midletsuite;

import com.sun.midp.midletsuite.InvalidJadException;
import com.sun.midp.midletsuite.JadProperties;
import com.sun.midp.midletsuite.JarManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class JadManager
extends JadProperties {
    private String jadName;
    private String jadVersion;
    private String jadVendor;
    private String jadJarURL;
    private String jadJarSize;
    private String jadMEConf;
    private String jadMEProfile;
    private String jadDesc;
    private String jadDataSize;
    private String jadIcon;
    private String jadInfoURL;
    private int numMIDlet;

    public String getName() {
        return this.jadName;
    }

    public String getVersion() {
        return this.jadVersion;
    }

    public String getVendor() {
        return this.jadVendor;
    }

    public String getURL() {
        return this.jadJarURL;
    }

    public boolean isJarURLAbsPath() {
        return new File(this.jadJarURL).isAbsolute();
    }

    public String getSize() {
        return this.jadJarSize;
    }

    public String getConfiguration() {
        return this.jadMEConf;
    }

    public String getProfile() {
        return this.jadMEProfile;
    }

    public String getDescription() {
        return this.jadDesc;
    }

    public String getDataSize() {
        return this.jadDataSize;
    }

    public String getIcon() {
        return this.jadIcon;
    }

    public String getInfoURL() {
        return this.jadInfoURL;
    }

    public int getNumMIDlet() {
        return this.numMIDlet;
    }

    private int prvGetNumMIDlet() {
        String string;
        int n = 0;
        while ((string = this.getProperty("MIDlet-" + (n + 1))) != null) {
            ++n;
        }
        return n;
    }

    public void testWithJARmanifest(JarManager jarManager) throws InvalidJadException {
        if (!this.jadName.equals(jarManager.getMIDletName())) {
            throw new InvalidJadException(25);
        }
        if (!this.jadVersion.equals(jarManager.getMIDletVersion())) {
            throw new InvalidJadException(26);
        }
        if (!this.jadVendor.equals(jarManager.getMIDletVendor())) {
            throw new InvalidJadException(27);
        }
    }

    public void JadManager() {
        this.numMIDlet = 0;
    }

    public synchronized void load(InputStream inputStream) throws IOException, InvalidJadException {
        super.load(inputStream);
        this.jadName = this.getProperty("MIDlet-Name");
        if (this.jadName == null) {
            throw new InvalidJadException(13);
        }
        this.jadVersion = this.getProperty("MIDlet-Version");
        if (this.jadVersion == null) {
            throw new InvalidJadException(15);
        }
        this.jadVendor = this.getProperty("MIDlet-Vendor");
        if (this.jadVendor == null) {
            throw new InvalidJadException(14);
        }
        this.jadJarURL = this.getProperty("MIDlet-Jar-URL");
        if (this.jadJarURL == null) {
            throw new InvalidJadException(18);
        }
        this.jadJarSize = this.getProperty("MIDlet-Jar-Size");
        if (this.jadJarSize == null) {
            throw new InvalidJadException(21);
        }
        this.numMIDlet = this.prvGetNumMIDlet();
        this.jadDesc = this.getProperty("MIDlet-Description");
        this.jadInfoURL = this.getProperty("MIDlet-Info-URL");
        this.jadIcon = this.getProperty("MIDlet-Icon");
        this.jadDataSize = this.getProperty("MIDlet-Data-Size");
    }
}

