/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.converter;

import com.sun.midp.converter.ConvertApp;
import com.sun.midp.midletsuite.InvalidJadException;
import com.sun.midp.midletsuite.JadProperties;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class caFileChooser
extends JFileChooser {
    PropertyChangeListener pcl = null;
    private File[] files;
    private Component comp;
    private JADPreviewer JADpreviewer;

    public File[] getFiles() {
        return this.files;
    }

    public String[] getFilenames() {
        String[] stringArray = null;
        int n = this.files.length;
        if (this.files.length > 0) {
            stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = this.files[n2].getPath();
                ++n2;
            }
        }
        return stringArray;
    }

    caFileChooser(Component component) {
        this.comp = component;
        this.setDialogTitle(ConvertApp.getResource("caFileChooser.Title"));
        this.setMultiSelectionEnabled(true);
        this.setFileSelectionMode(0);
        this.setApproveButtonToolTipText(ConvertApp.getResource("caFileChooser.Approve.TipText"));
        this.setApproveButtonText(ConvertApp.getResource("caFileChooser.Approve.Text"));
        this.setApproveButtonMnemonic(ConvertApp.getResource("caFileChooser.Approve.Mnemonic").charAt(0));
        this.addChoosableFileFilter(new JarOrJadFilter());
        this.JADpreviewer = new JADPreviewer();
        this.setAccessory(this.JADpreviewer);
        this.pcl = new caPropertyChangeListener();
    }

    public void showFileChooser() {
        this.files = null;
        this.addPropertyChangeListener(this.pcl);
        if (this.showDialog(this.comp, null) == 0) {
            this.files = this.getSelectedFiles();
        }
        this.cancelSelection();
        this.removePropertyChangeListener(this.pcl);
        this.JADpreviewer.setText("");
    }

    public boolean hasSelectedFiles() {
        if (this.files == null) {
            return false;
        }
        return this.files.length > 0 || this.files.length == 1 && this.files[0].isFile();
    }

    class JADPreviewer
    extends JPanel {
        private JTextArea textArea = new JTextArea();
        private JScrollPane scrollPane = new JScrollPane(this.textArea);
        private JadProperties jadp;

        public JADPreviewer() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), ConvertApp.getResource("caFileChooser.Jarfileneed")));
            this.textArea.setEditable(false);
            this.add((Component)this.scrollPane, "Center");
            this.setPreferredSize(new Dimension(150, 0));
        }

        public void setText(String string) {
            this.textArea.setText(string);
        }

        public void lookupFile(File file) {
            StringBuffer stringBuffer = new StringBuffer();
            this.jadp = new JadProperties();
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                this.jadp.load(fileInputStream, null);
                stringBuffer.append("Name:");
                stringBuffer.append(this.jadp.getProperty("MIDlet-Name"));
                stringBuffer.append("\n");
                stringBuffer.append("Jar file:");
                stringBuffer.append(this.jadp.getProperty("MIDlet-Jar-URL"));
                stringBuffer.append("\n");
                stringBuffer.append("Vendor:");
                stringBuffer.append(this.jadp.getProperty("MIDlet-Vendor"));
                stringBuffer.append("\n");
                stringBuffer.append("Version:");
                stringBuffer.append(this.jadp.getProperty("MIDlet-Version"));
                stringBuffer.append("\n");
                String string = this.jadp.getProperty("MIDlet-Description");
                if (string != null) {
                    stringBuffer.append("Description:");
                    stringBuffer.append(string);
                    stringBuffer.append("\n");
                }
                fileInputStream.close();
            }
            catch (NullPointerException nullPointerException) {
                stringBuffer.append("");
            }
            catch (InvalidJadException invalidJadException) {
                stringBuffer.append("Corrupted JAD file");
            }
            catch (IOException iOException) {
                stringBuffer.append("");
            }
            this.textArea.setText(stringBuffer.toString());
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ JADPreviewer this$1;
                {
                    this.this$1 = jADPreviewer;
                }

                public void run() {
                    JViewport jViewport = JADPreviewer.access$100(this.this$1).getViewport();
                    jViewport.setViewPosition(new Point(0, 0));
                }
            });
        }

        static /* synthetic */ JScrollPane access$100(JADPreviewer jADPreviewer) {
            return jADPreviewer.scrollPane;
        }
    }

    class JarOrJadFilter
    extends FileFilter {
        JarOrJadFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || this.correctSuffix(file);
        }

        public String getDescription() {
            return ConvertApp.getResource("caFileChooser.Description");
        }

        private boolean correctSuffix(File file) {
            String string;
            String string2 = file.getPath();
            int n = string2.lastIndexOf(46);
            return n < string2.length() - 1 && n > 0 && (string = string2.substring(n + 1).toLowerCase()) != null && string.equals("jad");
        }
    }

    public class caPropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("SelectedFileChangedProperty")) {
                caFileChooser.this.JADpreviewer.lookupFile((File)propertyChangeEvent.getNewValue());
            }
        }
    }
}

