/*
 * Decompiled with CFR 0.152.
 */
package example.wormgame;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class WormScore {
    private static short[] highScore = new short[10];
    private static String[] highScoreName = new String[10];
    private static RecordStore myStore;
    private static boolean highScoresHaveBeenInit;

    private WormScore() {
    }

    private static void initializeScores() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            byte[] b;
            try {
                dos.writeShort(0);
                dos.writeUTF("");
                b = baos.toByteArray();
                dos.close();
            }
            catch (IOException ioe) {
                throw new RecordStoreException();
            }
            int i = 0;
            while (i < 10) {
                myStore.addRecord(b, 0, b.length);
                ++i;
            }
        }
        catch (RecordStoreException rse) {
            WormScore.closeHighScores();
        }
    }

    static void openHighScores() {
        try {
            myStore = RecordStore.openRecordStore((String)"HighScores", (boolean)true);
            if (highScoresHaveBeenInit) {
                return;
            }
            if (myStore.getNumRecords() == 0) {
                WormScore.initializeScores();
            } else {
                int i = 0;
                while (i < 10) {
                    byte[] data = myStore.getRecord(i + 1);
                    if (data != null) {
                        try {
                            ByteArrayInputStream bais = new ByteArrayInputStream(data);
                            DataInputStream dis = new DataInputStream(bais);
                            WormScore.highScore[i] = dis.readShort();
                            WormScore.highScoreName[i] = dis.readUTF();
                            dis.close();
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
            }
            highScoresHaveBeenInit = true;
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    static void closeHighScores() {
        if (myStore != null) {
            try {
                myStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
            myStore = null;
        }
    }

    static void setHighScore(int level, int newScore, String name) {
        if (newScore <= highScore[level]) {
            return;
        }
        try {
            byte[] data;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream das = new DataOutputStream(baos);
                das.writeShort((short)newScore);
                das.writeUTF(name);
                data = baos.toByteArray();
                das.close();
            }
            catch (IOException ioe) {
                throw new RecordStoreException();
            }
            if (myStore == null) {
                WormScore.openHighScores();
                myStore.setRecord(level + 1, data, 0, data.length);
                WormScore.closeHighScores();
            } else {
                myStore.setRecord(level + 1, data, 0, data.length);
            }
        }
        catch (RecordStoreException rse) {
            // empty catch block
        }
        WormScore.highScore[level] = (short)newScore;
        WormScore.highScoreName[level] = name;
    }

    static short getHighScore(int level) {
        if (!highScoresHaveBeenInit) {
            WormScore.openHighScores();
            WormScore.closeHighScores();
        }
        return highScore[level];
    }

    static String getHighScoreName(int level) {
        if (!highScoresHaveBeenInit) {
            WormScore.openHighScores();
            WormScore.closeHighScores();
        }
        return highScoreName[level];
    }
}

