/*
 * Decompiled with CFR 0.152.
 */
package example.wormgame;

import example.wormgame.Worm;
import example.wormgame.WormException;
import example.wormgame.WormFood;
import example.wormgame.WormScore;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class WormPit
extends Canvas
implements Runnable {
    private WormFood myFood;
    private Worm myWorm;
    private boolean gameOver = true;
    private boolean gamePaused = false;
    private boolean gameRestart = false;
    private boolean forceRedraw = true;
    private int score = 0;
    private int level = 7;
    private int width = this.round(this.getWidth());
    private int height = this.round(this.getHeight() - SCORE_HEIGHT);
    static int CellWidth;
    static int CellHeight;
    private static final int START_POS = 3;
    private static final int SCORE_CHAR_HEIGHT;
    private static final int SCORE_CHAR_WIDTH;
    private static final int SCORE_HEIGHT;
    private static final int DEFAULT_WAIT = 400;
    static final byte MAX_LEVELS = 10;
    static final int FOOD_COLOUR = 65280;
    static final int TEXT_COLOUR = 0xFF0000;
    static final int ERASE_COLOUR = 0xFFFFFF;
    static final int DRAW_COLOUR = 0;
    public static final int CELL_SIZE = 5;

    public WormPit() {
        CellWidth = (this.width - 6) / 5;
        CellHeight = (this.height - 6) / 5;
        this.myWorm = new Worm(this);
        this.myFood = new WormFood(this);
        int x = this.myFood.getX();
        int y = this.myFood.getY();
        while (this.myWorm.contains(x, y)) {
            this.myFood.regenerate();
            x = this.myFood.getX();
            y = this.myFood.getY();
        }
    }

    private int round(int val) {
        int delta = (val - 6) % 5;
        return val - delta;
    }

    public void setLevel(int level) {
        if (this.level != level) {
            this.level = level;
            this.gameOver = true;
            this.gamePaused = false;
            this.score = 0;
        }
    }

    public int getLevel() {
        return this.level;
    }

    public int getScore() {
        return this.score;
    }

    static boolean isInBounds(int x, int y) {
        if (x < 0 || x >= CellWidth) {
            return false;
        }
        return y >= 0 && y < CellHeight;
    }

    void restart() {
        if (this.gamePaused) {
            this.gamePaused = false;
        } else {
            this.myWorm.regenerate();
            this.myFood.regenerate();
            this.score = 0;
            this.gameOver = false;
        }
        this.forceRedraw = true;
        Worm worm = this.myWorm;
        synchronized (worm) {
            this.myWorm.notifyAll();
        }
    }

    public void keyPressed(int keyCode) {
        block0 : switch (this.getGameAction(keyCode)) {
            case 1: {
                this.myWorm.setDirection((byte)8);
                break;
            }
            case 6: {
                this.myWorm.setDirection((byte)2);
                break;
            }
            case 2: {
                this.myWorm.setDirection((byte)4);
                break;
            }
            case 5: {
                this.myWorm.setDirection((byte)6);
                break;
            }
            case 0: {
                switch (keyCode) {
                    case 50: {
                        this.myWorm.setDirection((byte)8);
                        break block0;
                    }
                    case 56: {
                        this.myWorm.setDirection((byte)2);
                        break block0;
                    }
                    case 52: {
                        this.myWorm.setDirection((byte)4);
                        break block0;
                    }
                    case 54: {
                        this.myWorm.setDirection((byte)6);
                    }
                }
            }
        }
    }

    private void paintPitContents(Graphics g) {
        try {
            this.myWorm.update(g);
            if (this.myFood.isAt(this.myWorm.getX(), this.myWorm.getY())) {
                this.myWorm.eat();
                this.score += this.level;
                g.setColor(0xFFFFFF);
                g.fillRect(this.width - SCORE_CHAR_WIDTH * 3 - 3, this.height - 3, SCORE_CHAR_WIDTH * 3, SCORE_CHAR_HEIGHT);
                g.setColor(0);
                g.drawString("" + this.score, this.width - SCORE_CHAR_WIDTH * 3 - 3, this.height - 3, 0x10 | 4);
                this.myFood.regenerate();
                int x = this.myFood.getX();
                int y = this.myFood.getY();
                while (this.myWorm.contains(x, y)) {
                    this.myFood.regenerate();
                    x = this.myFood.getX();
                    y = this.myFood.getY();
                }
            }
            this.myFood.paint(g);
        }
        catch (WormException se) {
            this.gameOver = true;
        }
    }

    public void paint(Graphics g) {
        if (this.forceRedraw) {
            this.forceRedraw = false;
            g.setColor(0xFFFFFF);
            g.fillRect(0, 0, this.width, this.height + SCORE_HEIGHT + 5);
            g.setColor(0);
            g.drawRect(1, 1, this.width - 3, this.height - 3);
            g.drawString("L: " + this.level, 3, this.height, 0x10 | 4);
            g.drawString("" + this.score, this.width - SCORE_CHAR_WIDTH * 3, this.height, 0x10 | 4);
            g.drawString("S: ", this.width - SCORE_CHAR_WIDTH * 4, this.height, 0x10 | 8);
            g.drawString("" + this.score, this.width - SCORE_CHAR_WIDTH * 3, this.height, 0x10 | 4);
            g.drawString("H: ", this.width - SCORE_CHAR_WIDTH * 4, this.height + SCORE_CHAR_HEIGHT, 0x10 | 8);
            g.drawString("" + WormScore.getHighScore(this.level), this.width - SCORE_CHAR_WIDTH * 3, this.height + SCORE_CHAR_HEIGHT, 0x10 | 4);
            g.translate(3, 3);
            this.myWorm.paint(g);
            this.myFood.paint(g);
        } else {
            g.translate(3, 3);
        }
        if (this.gamePaused) {
            Font pauseFont = g.getFont();
            int fontH = pauseFont.getHeight();
            int fontW = pauseFont.stringWidth("Paused");
            g.setColor(0xFFFFFF);
            g.fillRect((this.width - fontW) / 2 - 1, (this.height - fontH) / 2, fontW + 2, fontH);
            g.setColor(0xFF0000);
            g.setFont(pauseFont);
            g.drawString("Paused", (this.width - fontW) / 2, (this.height - fontH) / 2, 0x10 | 4);
        } else if (this.gameOver) {
            Font overFont = g.getFont();
            int fontH = overFont.getHeight();
            int fontW = overFont.stringWidth("Game Over");
            g.setColor(0xFFFFFF);
            g.fillRect((this.width - fontW) / 2 - 1, (this.height - fontH) / 2, fontW + 2, fontH);
            g.setColor(0xFF0000);
            g.setFont(overFont);
            g.drawString("Game Over", (this.width - fontW) / 2, (this.height - fontH) / 2, 0x10 | 4);
        } else {
            this.paintPitContents(g);
        }
        g.translate(-3, -3);
    }

    protected void hideNotify() {
        super.hideNotify();
        this.forceRedraw = true;
        if (!this.gameOver) {
            this.gamePaused = true;
        }
    }

    public void run() {
        while (true) {
            try {
                Worm worm = this.myWorm;
                synchronized (worm) {
                    if (this.gameOver) {
                        if (WormScore.getHighScore(this.level) < this.score) {
                            WormScore.setHighScore(this.level, this.score, "me");
                        }
                        this.repaint();
                        this.myWorm.wait();
                    } else if (this.gamePaused) {
                        this.repaint();
                        this.myWorm.wait();
                    } else {
                        this.myWorm.moveOnUpdate();
                        this.repaint();
                        this.myWorm.wait(400 - this.level * 40);
                    }
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    static {
        Font defaultFont = Font.getDefaultFont();
        SCORE_CHAR_WIDTH = defaultFont.charWidth('S');
        SCORE_CHAR_HEIGHT = defaultFont.getHeight();
        SCORE_HEIGHT = SCORE_CHAR_HEIGHT * 2;
    }
}

