/*
 * Decompiled with CFR 0.152.
 */
package example.wormgame;

public class WormLink {
    private int x;
    private int y;
    private int len;
    private byte dir;

    private WormLink() {
    }

    public WormLink(int startX, int startY, int length, byte direction) {
        this.x = startX;
        this.y = startY;
        this.dir = direction;
        this.len = length - 1;
    }

    public WormLink(int startX, int startY, byte direction) {
        this(startX, startY, 1, direction);
    }

    public void increaseLength() {
        ++this.len;
    }

    public void decreaseLength() {
        --this.len;
        switch (this.dir) {
            case 4: {
                --this.x;
                break;
            }
            case 6: {
                ++this.x;
                break;
            }
            case 8: {
                --this.y;
                break;
            }
            case 2: {
                ++this.y;
            }
        }
    }

    public int getLength() {
        return this.len + 1;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getEndX() {
        if (this.dir == 4) {
            return this.x - this.len;
        }
        if (this.dir == 6) {
            return this.x + this.len;
        }
        return this.x;
    }

    public int getEndY() {
        if (this.dir == 2) {
            return this.y + this.len;
        }
        if (this.dir == 8) {
            return this.y - this.len;
        }
        return this.y;
    }

    public byte getDirection() {
        return this.dir;
    }

    public boolean contains(int x, int y) {
        switch (this.dir) {
            case 4: {
                return y == this.y && x <= this.x && x >= this.getEndX();
            }
            case 6: {
                return y == this.y && x >= this.x && x <= this.getEndX();
            }
            case 8: {
                return x == this.x && y <= this.y && y >= this.getEndY();
            }
            case 2: {
                return x == this.x && y >= this.y && y <= this.getEndY();
            }
        }
        return false;
    }

    public String toString() {
        String dirString;
        switch (this.dir) {
            case 4: {
                dirString = "Left";
                break;
            }
            case 6: {
                dirString = "Right";
                break;
            }
            case 8: {
                dirString = "Up";
                break;
            }
            case 2: {
                dirString = "Down";
                break;
            }
            default: {
                dirString = "UNKNOWN -- " + this.dir;
            }
        }
        return " pos == [" + this.x + "," + this.y + "]" + " - [" + this.getEndX() + "," + this.getEndY() + "]" + "   len == " + this.getLength() + "   dir == " + dirString;
    }
}

