/*
 * Decompiled with CFR 0.152.
 */
package example.wormgame;

import example.wormgame.WormException;
import example.wormgame.WormLink;
import example.wormgame.WormPit;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Worm {
    public static final byte DOWN = 2;
    public static final byte LEFT = 4;
    public static final byte RIGHT = 6;
    public static final byte UP = 8;
    private byte currentDirection;
    private Vector worm = new Vector(5, 2);
    private boolean needUpdate;
    private boolean moveOnNextUpdate;
    private boolean hasEaten;
    private static final int INIT_X = 3;
    private static final int INIT_Y = 8;
    private static final int INIT_LEN = 8;
    private static final byte INIT_DIR = 6;

    public Worm(WormPit pit) {
        this.regenerate();
    }

    public void regenerate() {
        Vector vector = this.worm;
        synchronized (vector) {
            this.worm.removeAllElements();
            this.worm.addElement(new WormLink(3, 8, 8, 6));
            this.currentDirection = (byte)6;
            this.needUpdate = false;
            this.hasEaten = false;
            this.moveOnNextUpdate = false;
        }
    }

    public void setDirection(byte direction) {
        Vector vector = this.worm;
        synchronized (vector) {
            if (direction != this.currentDirection && !this.needUpdate) {
                WormLink sl = (WormLink)this.worm.lastElement();
                int x = sl.getEndX();
                int y = sl.getEndY();
                switch (direction) {
                    case 8: {
                        if (this.currentDirection == 2) break;
                        --y;
                        this.needUpdate = true;
                        break;
                    }
                    case 2: {
                        if (this.currentDirection == 8) break;
                        ++y;
                        this.needUpdate = true;
                        break;
                    }
                    case 4: {
                        if (this.currentDirection == 6) break;
                        --x;
                        this.needUpdate = true;
                        break;
                    }
                    case 6: {
                        if (this.currentDirection == 4) break;
                        ++x;
                        this.needUpdate = true;
                    }
                }
                if (this.needUpdate) {
                    this.worm.addElement(new WormLink(x, y, 0, direction));
                    this.currentDirection = direction;
                }
            }
        }
    }

    public void moveOnUpdate() {
        Vector vector = this.worm;
        synchronized (vector) {
            this.moveOnNextUpdate = true;
        }
    }

    public void update(Graphics g) throws WormException {
        if (!this.moveOnNextUpdate) {
            return;
        }
        Vector vector = this.worm;
        synchronized (vector) {
            WormLink head = (WormLink)this.worm.lastElement();
            head.increaseLength();
            if (!this.hasEaten) {
                WormLink tail = (WormLink)this.worm.firstElement();
                int tailX = tail.getX();
                int tailY = tail.getY();
                tail.decreaseLength();
                if (tail.getLength() == 0) {
                    this.worm.removeElement(tail);
                }
                g.setColor(0xFFFFFF);
                this.drawLink(g, tailX, tailY, tailX, tailY, 1);
            } else {
                this.hasEaten = false;
            }
            this.needUpdate = false;
            if (!WormPit.isInBounds(head.getEndX(), head.getEndY())) {
                throw new WormException("over the edge");
            }
            byte headX = (byte)head.getEndX();
            byte headY = (byte)head.getEndY();
            g.setColor(0);
            this.drawLink(g, headX, headY, headX, headY, 1);
            int i = 0;
            while (i < this.worm.size() - 1) {
                WormLink sl = (WormLink)this.worm.elementAt(i);
                if (sl.contains(headX, headY)) {
                    throw new WormException("you ate yourself");
                }
                ++i;
            }
        }
    }

    public void drawLink(Graphics g, int x1, int y1, int x2, int y2, int len) {
        len *= 5;
        if (x1 == x2) {
            y1 = y2 < y1 ? y2 * 5 : (y1 *= 5);
            g.fillRect(x1 *= 5, y1, 5, len);
        } else {
            x1 = x2 < x1 ? x2 * 5 : (x1 *= 5);
            g.fillRect(x1, y1 *= 5, len, 5);
        }
    }

    public void paint(Graphics g) {
        int i = 0;
        while (i < this.worm.size()) {
            WormLink sl = (WormLink)this.worm.elementAt(i);
            int x1 = sl.getX();
            int x2 = sl.getEndX();
            int y1 = sl.getY();
            int y2 = sl.getEndY();
            int len = sl.getLength();
            this.drawLink(g, x1, y1, x2, y2, len);
            ++i;
        }
    }

    public void eat() {
        this.hasEaten = true;
    }

    public int getX() {
        Vector vector = this.worm;
        synchronized (vector) {
            int n = ((WormLink)this.worm.lastElement()).getEndX();
            return n;
        }
    }

    public int getY() {
        Vector vector = this.worm;
        synchronized (vector) {
            int n = ((WormLink)this.worm.lastElement()).getEndY();
            return n;
        }
    }

    public boolean contains(int x, int y) {
        Vector vector = this.worm;
        synchronized (vector) {
            int i = 0;
            while (i < this.worm.size()) {
                WormLink sl = (WormLink)this.worm.elementAt(i);
                if (sl.contains(x, y)) {
                    boolean bl = true;
                    return bl;
                }
                ++i;
            }
        }
        return false;
    }
}

