/* License
 * 
 * Copyright 1994-2004 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  
 *  * Redistribution of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 * 
 *  * Redistribution in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 * 
 * Neither the name of Sun Microsystems, Inc. or the names of contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *  
 * This software is provided "AS IS," without a warranty of any kind. ALL
 * EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING
 * ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN MICROSYSTEMS, INC. ("SUN")
 * AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE
 * AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
 * DERIVATIVES. IN NO EVENT WILL SUN OR ITS LICENSORS BE LIABLE FOR ANY LOST
 * REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL,
 * INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY
 * OF LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE THIS SOFTWARE,
 * EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 *  
 * You acknowledge that this software is not designed, licensed or intended
 * for use in the design, construction, operation or maintenance of any
 * nuclear facility. 
 */

import java.io.*;
import java.util.*;
import java.lang.*;
import javax.microedition.lcdui.*;
import javax.microedition.midlet.*;
import javax.microedition.rms.*;

public class RobRoller
    extends MIDlet 
    implements CommandListener {
  private Form mMainForm;
  private Form mSubForm;
  private StringItem disp;
  
  private TextField mkey; 
  private Random rnd;
  private TextField reroll;
  private ChoiceGroup rolltype;
  private RecordStore settings = null;
  public RobRoller() {
    mMainForm = new Form("nWOD Roller");
    mMainForm.append(mkey=new TextField("Pool","0",2,TextField.NUMERIC));
    disp = new StringItem("Result\n","");
    mMainForm.append(disp);
    mMainForm.addCommand(new Command("Roll", Command.EXIT,1));
    mMainForm.addCommand(new Command("Roll", Command.ITEM, 1));
    mMainForm.addCommand(new Command("Settings",Command.ITEM,2));
    mMainForm.addCommand(new Command("About",Command.ITEM,3));
    mMainForm.addCommand(new Command("Exit", Command.ITEM, 4));
    mMainForm.setCommandListener(this);
    mSubForm = new Form("Settings");
    reroll=new TextField("Reroll On","10",2,TextField.NUMERIC);
    mSubForm.append(reroll);
    String[] opts = {"Met(5)","Mage(3)","Dice","Hero"};
    rolltype = new ChoiceGroup("Type",Choice.EXCLUSIVE,opts,null);
    mSubForm.append(rolltype);
    mSubForm.addCommand(new Command("Ok",Command.ITEM,0));
    mSubForm.setCommandListener(this);
    rnd = new Random();
    loadsettings();
  }
  
  public void startApp() {
    Display.getDisplay(this).setCurrent(mMainForm);
  }
  
  public void pauseApp() {}
  
  public void destroyApp(boolean unconditional) 
  {
  }
  
  public boolean openstore()
  {
    if (settings==null) 
    {
      try
      {
	settings=RecordStore.openRecordStore("settings",true);
      }
      catch (RecordStoreException rse) 
      {
        System.out.println(rse);
        rse.printStackTrace();
	return false;
      }
    }
    return true;
  }
  
  public void loadsettings()
  {
    if (!openstore()) return;
    try
    {
      if (settings.getNumRecords()==0) return;
      byte[] b;
      b=settings.getRecord(1);
      ByteArrayInputStream bais = new ByteArrayInputStream(b);
      DataInputStream d = new DataInputStream(bais);
      try
      {
	mkey.setString(d.readUTF());
	reroll.setString(d.readUTF());
	rolltype.setSelectedIndex(d.readInt(),true);
      } catch (EOFException eof) {} // just stop reading at eof.  
    } 
    catch (RecordStoreException rse) 
    {
        System.out.println(rse);
        rse.printStackTrace();
    }
    catch (IOException io) {};
    updatescreen();
  }

  public void savesettings()
  {
    if (!openstore()) return;
    try
    {  
      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      DataOutputStream d = new DataOutputStream(baos);
      d.writeUTF(mkey.getString());
      d.writeUTF(reroll.getString());
      d.writeInt(rolltype.getSelectedIndex());
      byte[] b = baos.toByteArray();
      if (settings.getNumRecords()==0) settings.addRecord(b,0,b.length);
      else settings.setRecord(1,b,0,b.length);
    } 
//    catch (RecordStoreNotOpenException rno) {}
    catch (RecordStoreException rse) 
    {
        System.out.println(rse);
        rse.printStackTrace();
    }
    catch (IOException ioe) {};
  }
  
  private void updatescreen()
  {
    if (rolltype.getSelectedIndex()>=2) mkey.setLabel("Dice");
    else mkey.setLabel("Pool");
  }
  
  public int roll(int dice)
  {
    return ((rnd.nextInt() & 0x7fffffff) % dice)+1;
  }
  
  public void doroll()
  {
    String s1="";
    String result="";
    int skill=Integer.parseInt(mkey.getString());
    int d=roll(10);
    int rr=Integer.parseInt(reroll.getString());
    int succ;
    if (rolltype.getSelectedIndex()==3) // Hero
    {
      if (skill<1)
      {
	s1="No dice selected";
	result="Invalid";
      }
      else
      {
	int body=0;
	int total=0;
	for (int i=0; i<skill; i++)
	{
	  d=roll(6);
	  s1+=d+" ";
	  if (d==1) body += 0;
	  else if (d==6) body += 2;
	  else body += 1;
	  total=total+d;
	}
	result="N:Body="+body+" Stun="+total;
	s1="K:Body="+total+" Stun="+(total*3)+"\n"+s1;
      }
    }
    else if (skill==0) // Chance
    {
      int successes=0;
      s1="Chance";
      do
      {
	d=roll(10);
	s1 += " "+d;
	if (d==10) successes+=1;
      } while(d==10);
      if (successes>0) result = successes+" Successes";
      else result += "Failed";
    }
    else if (rolltype.getSelectedIndex()==2) // Dice
    {
      int successes=0;
      s1="Dice:"; 
      for (int i=0; i<skill; i++)
      {
	d=roll(10);
	s1 += " "+d;
	if (d==1) {successes -=1; s1+="-";}
	if (d>=7) {successes +=1; s1+="*";}
	while (d>=rr) 
	{
	  d=roll(10);
	  s1 += "+"+d;
	  if (d>=7) {successes +=1; s1+="*";}
	}
      }
      if (successes>0) result = successes+" Successes";
      else result += "Failed";
    }
    else //Met draw
    {  
      if (rolltype.getSelectedIndex()==1) succ=3; else succ=5;
      s1="Draw "+d+"\n";
      if (d==1) result = "Auto Failure";
      else
      {
	if (d>=rr) {int d1=roll(10); s1+="Redraw "+d1+"\n"; d+=d1;}
	int total=d+skill;
	s1 += "Total: "+d+"+"+skill+"="+total;
	if (total<10) result = "Fail";
	else result=(((total-10)/succ)+1)+" Successes";
      }
    }  
    disp.setLabel(result+"\n");
    disp.setText(s1);  
  }
  
  public void doabout()
  {
//    System.out.println("RobRoller\nRobbie Matthews\nAU2003100584\n21-Sep-2006");
    Alert a = new Alert("About");
    String v = getAppProperty("MIDlet-Version");
    a.setTimeout(Alert.FOREVER);
    a.setString("RobRoller "+v+"\nRobbie Matthews\n2003100584\n1-Oct-2006");
    Display.getDisplay(this).setCurrent(a);
  }

  public void commandAction(Command c, Displayable d) {
    String s = c.getLabel();
    if (s=="Exit")
    {
      savesettings();
      notifyDestroyed();
    }  
    else if (s=="About") doabout();
    else if (s=="Ok")
    {
      Display.getDisplay(this).setCurrent(mMainForm);
      updatescreen();
    }  
    else if (s=="Roll") doroll();
    else if (s=="Settings") Display.getDisplay(this).setCurrent(mSubForm);
  }
}
