/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class RobRoller
extends MIDlet
implements CommandListener {
    private Form mMainForm = new Form("nWOD Roller");
    private Form mSubForm;
    private StringItem disp;
    private TextField mkey = new TextField("Pool", "0", 2, 2);
    private Random rnd;
    private TextField reroll;
    private ChoiceGroup rolltype;
    private RecordStore settings = null;

    public RobRoller() {
        this.mMainForm.append((Item)this.mkey);
        this.disp = new StringItem("Result\n", "");
        this.mMainForm.append((Item)this.disp);
        this.mMainForm.addCommand(new Command("Roll", 7, 1));
        this.mMainForm.addCommand(new Command("Roll", 8, 1));
        this.mMainForm.addCommand(new Command("Settings", 8, 2));
        this.mMainForm.addCommand(new Command("About", 8, 3));
        this.mMainForm.addCommand(new Command("Exit", 8, 4));
        this.mMainForm.setCommandListener((CommandListener)this);
        this.mSubForm = new Form("Settings");
        this.reroll = new TextField("Reroll On", "10", 2, 2);
        this.mSubForm.append((Item)this.reroll);
        String[] stringArray = new String[]{"Met(5)", "Mage(3)", "Dice", "Hero"};
        this.rolltype = new ChoiceGroup("Type", 1, stringArray, null);
        this.mSubForm.append((Item)this.rolltype);
        this.mSubForm.addCommand(new Command("Ok", 8, 0));
        this.mSubForm.setCommandListener((CommandListener)this);
        this.rnd = new Random();
        this.loadsettings();
    }

    public void startApp() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.mMainForm);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
    }

    public boolean openstore() {
        if (this.settings == null) {
            try {
                this.settings = RecordStore.openRecordStore((String)"settings", (boolean)true);
            }
            catch (RecordStoreException recordStoreException) {
                System.out.println((Object)recordStoreException);
                recordStoreException.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public void loadsettings() {
        if (!this.openstore()) {
            return;
        }
        try {
            if (this.settings.getNumRecords() == 0) {
                return;
            }
            byte[] byArray = this.settings.getRecord(1);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            try {
                this.mkey.setString(dataInputStream.readUTF());
                this.reroll.setString(dataInputStream.readUTF());
                this.rolltype.setSelectedIndex(dataInputStream.readInt(), true);
            }
            catch (EOFException eOFException) {}
        }
        catch (RecordStoreException recordStoreException) {
            System.out.println((Object)recordStoreException);
            recordStoreException.printStackTrace();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.updatescreen();
    }

    public void savesettings() {
        if (!this.openstore()) {
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeUTF(this.mkey.getString());
            dataOutputStream.writeUTF(this.reroll.getString());
            dataOutputStream.writeInt(this.rolltype.getSelectedIndex());
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (this.settings.getNumRecords() == 0) {
                this.settings.addRecord(byArray, 0, byArray.length);
            } else {
                this.settings.setRecord(1, byArray, 0, byArray.length);
            }
        }
        catch (RecordStoreException recordStoreException) {
            System.out.println((Object)recordStoreException);
            recordStoreException.printStackTrace();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void updatescreen() {
        if (this.rolltype.getSelectedIndex() >= 2) {
            this.mkey.setLabel("Dice");
        } else {
            this.mkey.setLabel("Pool");
        }
    }

    public int roll(int n) {
        return (this.rnd.nextInt() & Integer.MAX_VALUE) % n + 1;
    }

    public void doroll() {
        String string = "";
        String string2 = "";
        int n = Integer.parseInt(this.mkey.getString());
        int n2 = this.roll(10);
        int n3 = Integer.parseInt(this.reroll.getString());
        if (this.rolltype.getSelectedIndex() == 3) {
            if (n < 1) {
                string = "No dice selected";
                string2 = "Invalid";
            } else {
                int n4 = 0;
                int n5 = 0;
                for (int i = 0; i < n; ++i) {
                    n2 = this.roll(6);
                    string = string + n2 + " ";
                    n4 = n2 == 1 ? (n4 += 0) : (n2 == 6 ? (n4 += 2) : ++n4);
                    n5 += n2;
                }
                string2 = "N:Body=" + n4 + " Stun=" + n5;
                string = "K:Body=" + n5 + " Stun=" + n5 * 3 + "\n" + string;
            }
        } else if (n == 0) {
            int n6 = 0;
            string = "Chance";
            do {
                n2 = this.roll(10);
                string = string + " " + n2;
                if (n2 != 10) continue;
                ++n6;
            } while (n2 == 10);
            string2 = n6 > 0 ? n6 + " Successes" : string2 + "Failed";
        } else if (this.rolltype.getSelectedIndex() == 2) {
            int n7 = 0;
            string = "Dice:";
            for (int i = 0; i < n; ++i) {
                n2 = this.roll(10);
                string = string + " " + n2;
                if (n2 == 1) {
                    --n7;
                    string = string + "-";
                }
                if (n2 >= 7) {
                    ++n7;
                    string = string + "*";
                }
                while (n2 >= n3) {
                    n2 = this.roll(10);
                    string = string + "+" + n2;
                    if (n2 < 7) continue;
                    ++n7;
                    string = string + "*";
                }
            }
            string2 = n7 > 0 ? n7 + " Successes" : string2 + "Failed";
        } else {
            int n8 = this.rolltype.getSelectedIndex() == 1 ? 3 : 5;
            string = "Draw " + n2 + "\n";
            if (n2 == 1) {
                string2 = "Auto Failure";
            } else {
                int n9;
                if (n2 >= n3) {
                    n9 = this.roll(10);
                    string = string + "Redraw " + n9 + "\n";
                    n2 += n9;
                }
                n9 = n2 + n;
                string = string + "Total: " + n2 + "+" + n + "=" + n9;
                string2 = n9 < 10 ? "Fail" : (n9 - 10) / n8 + 1 + " Successes";
            }
        }
        this.disp.setLabel(string2 + "\n");
        this.disp.setText(string);
    }

    public void doabout() {
        Alert alert = new Alert("About");
        String string = this.getAppProperty("MIDlet-Version");
        alert.setTimeout(-2);
        alert.setString("RobRoller " + string + "\nRobbie Matthews\n2003100584\n1-Oct-2006");
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)alert);
    }

    public void commandAction(Command command, Displayable displayable) {
        String string = command.getLabel();
        if (string == "Exit") {
            this.savesettings();
            this.notifyDestroyed();
        } else if (string == "About") {
            this.doabout();
        } else if (string == "Ok") {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.mMainForm);
            this.updatescreen();
        } else if (string == "Roll") {
            this.doroll();
        } else if (string == "Settings") {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.mSubForm);
        }
    }
}

